/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.exp;

import fig.basic.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import nuts.io.IO;
import nuts.math.Plot2D;
import nuts.util.CollUtils;

public class CreateGraph
implements Runnable {
    public static void main(String[] args) {
        IO.run(args, new CreateGraph());
    }

    @Override
    public void run() {
        Plot2D.Plot2DOptions options = new Plot2D.Plot2DOptions();
        options.xlogscale = true;
        String prefix = "graph-data-";
        for (int graphIdx = 1; graphIdx <= 2; ++graphIdx) {
            Plot2D cur = new Plot2D(options);
            for (String method : Arrays.asList("smc", "mcmc")) {
                ArrayList<Pair<Double, Double>> curList = CollUtils.list();
                for (String line : IO.i(new File(prefix + graphIdx + ".txt." + method))) {
                    if (line.matches("^//s*$")) continue;
                    String[] fields = line.split("\\s+");
                    curList.add(Pair.makePair(Double.parseDouble(fields[0]), Double.parseDouble(fields[1])));
                }
                cur.addSeries(curList, true, method.toUpperCase());
            }
            cur.savePlot(new File("../graphics/graph" + (graphIdx == 1 ? "-med" : "") + ".pdf"));
        }
    }
}

