/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.Taxon;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import ma.newick.NewickParser;
import ma.newick.ParseException;
import nuts.util.Arbre;
import pty.RootedTree;
import pty.Train;
import pty.eval.SymmetricDiff;
import pty.io.Dataset;
import pty.io.HGDPDataset;
import pty.smc.ConstrainedKernel;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import pty.smc.PostPostKernel;
import pty.smc.PriorPostKernel;
import pty.smc.PriorPriorKernel;
import pty.smc.models.BrownianModel;

public class TestBrownianModel
implements Runnable {
    @Option
    public static final boolean test = false;
    public static ParticleFilter<PartialCoalescentState> pf = new ParticleFilter();
    public static final Random rand = new Random(1L);
    @Option
    public KernelType kernelType = KernelType.POST_POST;
    @Option
    public String constraintsFile = "";
    @Option
    public boolean usePriorPost = false;
    @Option
    public double variance = 1.0;
    @Option
    public boolean linesearch = true;
    PartialCoalescentState genepcs;
    PartialCoalescentState langpcs;

    public static void main(String[] args) {
        Execution.monitor = true;
        Execution.makeThunk = false;
        Execution.create = true;
        Execution.useStandardExecPoolDirStrategy = true;
        Execution.run(args, new TestBrownianModel(), "hgdp", HGDPDataset.class, "kernel", ConstrainedKernel.class, "filter", pf, "pcs", PartialCoalescentState.class, "ppk", PriorPriorKernel.class);
    }

    public static PartialCoalescentState initGeneState(double variance) {
        Dataset data = Dataset.DatasetType.HGDP.loadDataset();
        BrownianModel bm = new BrownianModel(data.nSites(), variance);
        return PartialCoalescentState.initState(data, bm, false);
    }

    public void sample(PartialCoalescentState initGeneState) {
        ParticleKernel<PartialCoalescentState> ppk = this.kernelType.load(initGeneState, this.constraintsFile);
        ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, PartialCoalescentState> mapd = ParticleFilter.ParticleMapperProcessor.saveCoalescentParticlesProcessor();
        ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> mbr = SymmetricDiff.createCladeProcessor();
        ParticleFilter.PCSHash hashProcessor = new ParticleFilter.PCSHash();
        ParticleFilter.ForkedProcessor forked = new ParticleFilter.ForkedProcessor(mapd, mbr, hashProcessor);
        pf.sample(ppk, forked);
        PartialCoalescentState pcs = mapd.map();
        RootedTree map = pcs.getFullCoalescentState();
        String prefix = "map-tree.variance-" + this.variance;
        Train.outputTree(map.topology(), prefix, map.branchLengths());
        Train.outputTree(SymmetricDiff.clades2arbre(mbr.centroid(SymmetricDiff.CLADE_SYMMETRIC_DIFFERENCE)), "mbr-tree");
        LogInfo.logs("Log likelihood of map-tree:" + pcs.logLikelihood() + " with variance = " + this.variance);
        LogInfo.logs("Marginal log likelihood:" + pf.estimateNormalizer() + " with variance = " + this.variance);
        LogInfo.logs("Height of map tree: " + pcs.topHeight());
        LogInfo.logs("Hash=" + hashProcessor.getHash());
    }

    public static final double logNormalDensity(double x, double mean, double var) {
        return -0.5 * (x - mean) * (x - mean) / var - 0.5 * Math.log(Math.PI * 2 * var);
    }

    @Override
    public void run() {
        if (this.linesearch) {
            this.variance = 100000.0;
            int i = 0;
            while (i <= 10) {
                PartialCoalescentState geneState = TestBrownianModel.initGeneState(this.variance);
                this.sample(geneState);
                ++i;
                this.variance /= 10.0;
            }
        } else {
            PartialCoalescentState geneState = TestBrownianModel.initGeneState(this.variance);
            this.sample(geneState);
        }
        double lz1 = TestBrownianModel.logNormalDensity(0.0, 0.0, 8.5);
        double lz2 = TestBrownianModel.logNormalDensity(0.0, 0.0, 7.0);
        double ll = lz2 + 2.0 * lz1;
        System.out.println("ll = " + ll + "\tlz1 = " + lz1);
        double lz = TestBrownianModel.logNormalDensity(0.0, 0.0, 2.0);
        System.out.println("Height 1 = " + lz);
        lz = TestBrownianModel.logNormalDensity(0.0, 0.0, 3.0);
        System.out.println("Height 2 = " + lz);
        lz = TestBrownianModel.logNormalDensity(0.0, 0.0, 4.0);
        System.out.println("Height 3 = " + lz);
        lz = TestBrownianModel.logNormalDensity(0.0, 0.0, 5.0);
        System.out.println("Height 1 = " + lz);
    }

    public static enum KernelType {
        PRIOR_POST{

            @Override
            public ParticleKernel<PartialCoalescentState> load(PartialCoalescentState initial, String constraintFile) {
                return new PriorPostKernel(initial);
            }
        }
        ,
        POST_POST{

            @Override
            public ParticleKernel<PartialCoalescentState> load(PartialCoalescentState initial, String constraintFile) {
                return new PostPostKernel(initial);
            }
        }
        ,
        PRIOR_PRIOR{

            @Override
            public ParticleKernel<PartialCoalescentState> load(PartialCoalescentState initial, String constraintFile) {
                return new PriorPriorKernel(initial);
            }
        }
        ,
        PRIOR_POST2{

            @Override
            public ParticleKernel<PartialCoalescentState> load(PartialCoalescentState initial, String constraintFile) {
                ConstrainedKernel.usesPriorPost = true;
                return new ConstrainedKernel(initial, new HashSet<Set<Taxon>>());
            }
        }
        ,
        CONSTRAINED{

            @Override
            public ParticleKernel<PartialCoalescentState> load(PartialCoalescentState initial, String constraintFile) {
                try {
                    NewickParser np = new NewickParser(IOUtils.openInHard(constraintFile));
                    Arbre<Taxon> a = Taxon.LanguageUtils.convert(Arbre.tree2Arbre(np.parse()));
                    return new ConstrainedKernel(initial, SymmetricDiff.clades(a));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        };


        public abstract ParticleKernel<PartialCoalescentState> load(PartialCoalescentState var1, String var2);
    }
}

