/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class KClique {
    public static UndirectedGraph randomGraph(int n, double p, Random rand) {
        if (p < 0.0 || p > 1.0 || n < 0) {
            throw new RuntimeException();
        }
        UndirectedGraph g = new UndirectedGraph(n);
        for (int v = 0; v < n; ++v) {
            for (int w = v + 1; w < n; ++w) {
                if (!(rand.nextDouble() < p)) continue;
                g.addEdge(v, w);
            }
        }
        return g;
    }

    public static int Nprime(UndirectedGraph g, Set<Integer> clique, Set<Set<Integer>> workingSet) {
        int n = 0;
        for (Set<Integer> otherClique : workingSet) {
            if (!KClique.intersects(otherClique, clique) || otherClique.equals(clique)) continue;
            ++n;
        }
        return n;
    }

    public static void prune(int k, UndirectedGraph g, Set<Set<Integer>> workingSet) {
        Iterator<Set<Integer>> iterator = workingSet.iterator();
        while (iterator.hasNext()) {
            Set<Integer> current = iterator.next();
            int Nprime = KClique.Nprime(g, current, workingSet);
            if (Nprime + current.size() >= k) continue;
            iterator.remove();
        }
    }

    public static void main(String[] args) {
        int n = 500;
        double p = 0.5;
        for (int k = 2; k < n; ++k) {
            if (KClique.findKClique(KClique.randomGraph(n, p, new Random()), k)) continue;
            return;
        }
    }

    public static boolean findKClique(UndirectedGraph g, int k) {
        Set<Set<Integer>> workingSet = KClique.initial(g);
        for (int cliqueSize = 2; cliqueSize < k; ++cliqueSize) {
            int oldWorkingSetSize;
            int newWorkingSetSize;
            do {
                oldWorkingSetSize = workingSet.size();
                KClique.prune(k, g, workingSet);
                newWorkingSetSize = workingSet.size();
                System.out.println("Working set reduced from " + oldWorkingSetSize + " to " + newWorkingSetSize);
            } while (newWorkingSetSize < oldWorkingSetSize);
            workingSet = KClique.next(g, workingSet);
        }
        if (workingSet.size() > 0) {
            System.out.println("" + workingSet.size() + " " + k + "-cliques found");
            return true;
        }
        System.out.println("No " + k + "-clique found");
        return false;
    }

    public static Set<Set<Integer>> initial(UndirectedGraph g) {
        HashSet<Set<Integer>> result = new HashSet<Set<Integer>>();
        for (int i = 0; i < g.size; ++i) {
            for (int j = i + 1; j < g.size; ++j) {
                if (!g.hasEdge(i, j)) continue;
                HashSet<Integer> clique = new HashSet<Integer>();
                clique.add(i);
                clique.add(j);
                result.add(clique);
            }
        }
        return result;
    }

    public static Set<Set<Integer>> next(UndirectedGraph g, Set<Set<Integer>> oldWorkingSet) {
        HashSet<Set<Integer>> newWorkingSet = new HashSet<Set<Integer>>();
        for (Set<Integer> oldClique : oldWorkingSet) {
            for (int v = 0; v < g.size; ++v) {
                if (oldClique.contains(v)) continue;
                HashSet<Integer> candidate = new HashSet<Integer>(oldClique);
                candidate.add(v);
                if (!g.isClique(new ArrayList<Integer>(candidate))) continue;
                newWorkingSet.add(candidate);
            }
        }
        return newWorkingSet;
    }

    public static <T> boolean intersects(Set<T> s1, Set<T> s2) {
        for (T e : s1) {
            if (!s2.contains(e)) continue;
            return true;
        }
        return false;
    }

    public static class UndirectedGraph {
        public final int size;
        private final Set<Pair<Integer, Integer>> edges = new HashSet<Pair<Integer, Integer>>();

        public UndirectedGraph(int size) {
            this.size = size;
        }

        public void addEdge(int v, int w) {
            if (this.hasEdge(v, w)) {
                throw new RuntimeException();
            }
            this.edges.add(this.getKey(v, w));
        }

        public boolean hasEdge(int v, int w) {
            return this.edges.contains(this.getKey(v, w));
        }

        private Pair<Integer, Integer> getKey(int v, int w) {
            if (v < 0 || w < 0 || v >= this.size || w >= this.size) {
                throw new RuntimeException();
            }
            if (v > w) {
                return Pair.newPair(v, w);
            }
            return Pair.newPair(w, v);
        }

        public boolean isClique(List<Integer> nodes) {
            for (int i = 0; i < nodes.size(); ++i) {
                for (int j = i + 1; j < nodes.size(); ++j) {
                    if (this.hasEdge(nodes.get(i), nodes.get(j))) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

