/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.DoubleTridiagonalMatrix;
import JSci.maths.polynomials.RealPolynomial;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.ComplexVector;
import JSci.maths.vectors.DoubleVector;

public final class LinearMath
extends AbstractMath {
    private static final int EIGEN_MAX_ITERATIONS = Integer.getInteger("JSci.maths.eigen.iters", 250);

    private LinearMath() {
    }

    public static AbstractDoubleVector solve(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix, AbstractDoubleVector abstractDoubleVector) {
        int n;
        double d;
        int n2;
        int n3 = abstractDoubleVector.dimension();
        double[] dArray = new double[n3];
        int[] nArray = new int[n3 + 1];
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = abstractDoubleSquareMatrix.luDecompose(nArray);
        for (n2 = 0; n2 < n3; ++n2) {
            d = abstractDoubleVector.getComponent(nArray[n2]);
            for (n = 0; n < n2; ++n) {
                d -= abstractDoubleSquareMatrixArray[0].getElement(n2, n) * dArray[n];
            }
            dArray[n2] = d / abstractDoubleSquareMatrixArray[0].getElement(n2, n2);
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            d = dArray[n2];
            for (n = n2 + 1; n < n3; ++n) {
                d -= abstractDoubleSquareMatrixArray[1].getElement(n2, n) * dArray[n];
            }
            dArray[n2] = d / abstractDoubleSquareMatrixArray[1].getElement(n2, n2);
        }
        return new DoubleVector(dArray);
    }

    private static double[] solveCholesky(double[][] dArray, double[] dArray2) {
        int n;
        double d;
        int n2;
        int n3 = dArray2.length;
        double[] dArray3 = new double[n3];
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new DoubleSquareMatrix(dArray).choleskyDecompose();
        for (n2 = 0; n2 < n3; ++n2) {
            d = dArray2[n2];
            for (n = 0; n < n2; ++n) {
                d -= abstractDoubleSquareMatrixArray[0].getElement(n2, n) * dArray3[n];
            }
            dArray3[n2] = d / abstractDoubleSquareMatrixArray[0].getElement(n2, n2);
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            d = dArray3[n2];
            for (n = n2 + 1; n < n3; ++n) {
                d -= abstractDoubleSquareMatrixArray[1].getElement(n2, n) * dArray3[n];
            }
            dArray3[n2] = d / abstractDoubleSquareMatrixArray[1].getElement(n2, n2);
        }
        return dArray3;
    }

    private static double[] solveQR(double[][] dArray, double[] dArray2) {
        int n;
        double d;
        int n2;
        int n3 = dArray2.length;
        double[] dArray3 = new double[n3];
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new DoubleSquareMatrix(dArray).qrDecompose();
        for (n2 = 0; n2 < n3; ++n2) {
            d = 0.0;
            for (n = 0; n < n3; ++n) {
                d += abstractDoubleSquareMatrixArray[0].getElement(n, n2) * dArray2[n];
            }
            dArray3[n2] = d;
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            d = dArray3[n2];
            for (n = n2 + 1; n < n3; ++n) {
                d -= abstractDoubleSquareMatrixArray[1].getElement(n2, n) * dArray3[n];
            }
            dArray3[n2] = d / abstractDoubleSquareMatrixArray[1].getElement(n2, n2);
        }
        return dArray3;
    }

    public static AbstractDoubleVector solveGMRes(AbstractDoubleMatrix abstractDoubleMatrix, AbstractDoubleVector abstractDoubleVector, int n, double d) throws MaximumIterationsExceededException {
        double d2;
        if (n <= 0) {
            throw new IllegalArgumentException("Number of allowed iterations must be a positive integer: " + n + " <= 0.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive or zero: " + d + " < 0.");
        }
        int n2 = abstractDoubleMatrix.rows();
        int n3 = 1;
        double[] dArray = new double[n2 + 1];
        double[][] dArray2 = new double[n2 + 1][2];
        double[] dArray3 = new double[2];
        AbstractDoubleVector abstractDoubleVector2 = new DoubleVector(abstractDoubleMatrix.rows());
        double d3 = abstractDoubleVector.norm();
        AbstractDoubleVector abstractDoubleVector3 = abstractDoubleVector.subtract(abstractDoubleMatrix.multiply(abstractDoubleVector2));
        double d4 = abstractDoubleVector3.norm();
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        double d5 = abstractDoubleVector3.norm() / d3;
        if (d2 <= d) {
            d = d5;
            n = 0;
            throw new IllegalArgumentException("There is a bug.");
        }
        AbstractDoubleVector[] abstractDoubleVectorArray = new DoubleVector[n2 + 1];
        double[][] dArray4 = new double[n2 + 1][n2];
        while (n3 <= n) {
            double d6;
            int n4;
            abstractDoubleVectorArray[0] = abstractDoubleVector3.scalarMultiply(1.0 / d4);
            for (n4 = 0; n4 < n2 + 1; ++n4) {
                dArray[n4] = 0.0;
            }
            dArray[0] = d4;
            for (n4 = 0; n4 < n2 && n3 <= n; ++n4, ++n3) {
                double d7;
                int n5;
                AbstractDoubleVector abstractDoubleVector4 = abstractDoubleMatrix.multiply(abstractDoubleVectorArray[n4]);
                for (n5 = 0; n5 <= n4; ++n5) {
                    dArray4[n5][n4] = abstractDoubleVector4.scalarProduct(abstractDoubleVectorArray[n5]);
                    abstractDoubleVector4 = abstractDoubleVector4.subtract(abstractDoubleVectorArray[n5].scalarMultiply(dArray4[n5][n4]));
                }
                dArray4[n4 + 1][n4] = abstractDoubleVector4.norm();
                abstractDoubleVectorArray[n4 + 1] = abstractDoubleVector4.scalarMultiply(1.0 / dArray4[n4 + 1][n4]);
                for (n5 = 0; n5 < n4; ++n5) {
                    dArray3 = LinearMath.applyPlaneRotation(dArray4[n5][n4], dArray4[n5 + 1][n4], dArray2[n5][0], dArray2[n5][1]);
                    dArray4[n5][n4] = dArray3[0];
                    dArray4[n5 + 1][n4] = dArray3[1];
                }
                dArray2[n4] = LinearMath.generatePlaneRotation(dArray4[n4][n4], dArray4[n4 + 1][n4]);
                dArray3 = LinearMath.applyPlaneRotation(dArray4[n4][n4], dArray4[n4 + 1][n4], dArray2[n4][0], dArray2[n4][1]);
                dArray4[n4][n4] = dArray3[0];
                dArray4[n4 + 1][n4] = dArray3[1];
                dArray3 = LinearMath.applyPlaneRotation(dArray[n4], dArray[n4 + 1], dArray2[n4][0], dArray2[n4][1]);
                dArray[n4] = dArray3[0];
                dArray[n4 + 1] = dArray3[1];
                d5 = Math.abs(dArray[n4 + 1]) / d3;
                if (!(d7 < d)) continue;
                abstractDoubleVector2 = LinearMath.update(abstractDoubleVector2, n4, dArray4, dArray, abstractDoubleVectorArray);
                d = d5;
                n = n3;
                return abstractDoubleVector2;
            }
            abstractDoubleVector2 = LinearMath.update(abstractDoubleVector2, n2 - 1, dArray4, dArray, abstractDoubleVectorArray);
            abstractDoubleVector3 = abstractDoubleVector.subtract(abstractDoubleMatrix.multiply(abstractDoubleVector2));
            d4 = abstractDoubleVector3.norm();
            d5 = d4 / d3;
            if (!(d6 < d)) continue;
            d = d5;
            n = n3;
            return abstractDoubleVector2;
        }
        d = d5;
        throw new MaximumIterationsExceededException("(tol) " + d + ". It doesn't converge in " + n + "iterations. Try raising the number of allowed iterations or raising the tolerance.", abstractDoubleVector2);
    }

    private static double[] generatePlaneRotation(double d, double d2) {
        double[] dArray = new double[2];
        if (d2 == 0.0) {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
        } else if (Math.abs(d2) > Math.abs(d)) {
            double d3 = d / d2;
            dArray[1] = 1.0 / Math.sqrt(1.0 + d3 * d3);
            dArray[0] = d3 * dArray[1];
        } else {
            double d4 = d2 / d;
            dArray[0] = 1.0 / Math.sqrt(1.0 + d4 * d4);
            dArray[1] = d4 * dArray[0];
        }
        return dArray;
    }

    private static double[] applyPlaneRotation(double d, double d2, double d3, double d4) {
        double[] dArray = new double[]{d3 * d + d4 * d2, -d4 * d + d3 * d2};
        return dArray;
    }

    private static AbstractDoubleVector update(AbstractDoubleVector abstractDoubleVector, int n, double[][] dArray, double[] dArray2, AbstractDoubleVector[] abstractDoubleVectorArray) {
        int n2;
        for (n2 = n; n2 >= 0; --n2) {
            dArray2[n2] = dArray2[n2] / dArray[n2][n2];
            for (int i = n2 - 1; i >= 0; --i) {
                dArray2[i] = dArray2[i] - dArray[i][n2] * dArray2[n2];
            }
        }
        for (n2 = 0; n2 <= n; ++n2) {
            abstractDoubleVector = abstractDoubleVector.add(abstractDoubleVectorArray[n2].scalarMultiply(dArray2[n2]));
        }
        return abstractDoubleVector;
    }

    public static RealPolynomial leastSquaresFit(int n, double[][] dArray) {
        int n2;
        double d;
        int n3;
        int n4 = n++;
        double[][] dArray2 = new double[n][n];
        double[] dArray3 = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            double d2 = 0.0;
            d = 0.0;
            for (n2 = 0; n2 < dArray[0].length; ++n2) {
                double d3 = Math.pow(dArray[0][n2], n3);
                d += d3;
                d2 += d3 * dArray[1][n2];
            }
            dArray2[0][n3] = d;
            dArray3[n3] = d2;
        }
        for (n3 = 1; n3 < n; ++n3) {
            System.arraycopy(dArray2[n3 - 1], 1, dArray2[n3], 0, n4);
            d = 0.0;
            for (n2 = 0; n2 < dArray[0].length; ++n2) {
                d += Math.pow(dArray[0][n2], n4 + n3);
            }
            dArray2[n3][n4] = d;
        }
        return new RealPolynomial(LinearMath.solveCholesky(dArray2, dArray3));
    }

    public static AbstractDoubleVector linearRegression(double[][] dArray) {
        int n;
        double d;
        int n2;
        int n3 = dArray.length - 1;
        double[][] dArray2 = new double[dArray.length][dArray.length];
        double[] dArray3 = new double[dArray.length];
        dArray2[0][0] = dArray[0].length;
        for (n2 = 1; n2 < dArray.length; ++n2) {
            d = 0.0;
            for (n = 0; n < dArray[0].length; ++n) {
                d += dArray[n2 - 1][n];
            }
            double d2 = d;
            dArray2[n2][0] = d2;
            dArray2[0][n2] = d2;
        }
        double d3 = 0.0;
        for (n = 0; n < dArray[0].length; ++n) {
            d3 += dArray[n3][n];
        }
        dArray3[0] = d3;
        for (int i = 1; i < dArray.length; ++i) {
            for (n2 = i; n2 < dArray.length; ++n2) {
                d = 0.0;
                for (n = 0; n < dArray[0].length; ++n) {
                    d += dArray[i - 1][n] * dArray[n2 - 1][n];
                }
                double d4 = d;
                dArray2[n2][i] = d4;
                dArray2[i][n2] = d4;
            }
            d3 = 0.0;
            for (n = 0; n < dArray[0].length; ++n) {
                d3 += dArray[i - 1][n] * dArray[n3][n];
            }
            dArray3[i] = d3;
        }
        return new DoubleVector(LinearMath.solveCholesky(dArray2, dArray3));
    }

    public static AbstractDoubleVector[] orthonormalize(AbstractDoubleVector[] abstractDoubleVectorArray) {
        int n = abstractDoubleVectorArray.length;
        AbstractDoubleVector[] abstractDoubleVectorArray2 = new DoubleVector[n];
        for (int i = 0; i < n; ++i) {
            abstractDoubleVectorArray2[i] = abstractDoubleVectorArray[i];
            for (int j = 0; j < i; ++j) {
                abstractDoubleVectorArray2[i] = abstractDoubleVectorArray2[i].subtract(abstractDoubleVectorArray2[j].scalarMultiply(abstractDoubleVectorArray2[j].scalarProduct(abstractDoubleVectorArray2[i])));
            }
            abstractDoubleVectorArray2[i] = abstractDoubleVectorArray2[i].normalize();
        }
        return abstractDoubleVectorArray2;
    }

    public static double[] eigenvalueSolveHermitian(AbstractComplexSquareMatrix abstractComplexSquareMatrix) throws MaximumIterationsExceededException {
        int n = abstractComplexSquareMatrix.rows();
        double[][] dArray = new double[2 * n][2 * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = abstractComplexSquareMatrix.getRealElement(i, j);
                double d2 = abstractComplexSquareMatrix.getImagElement(i, j);
                dArray[i][j] = d;
                dArray[n + i][n + j] = d;
                dArray[n + i][j] = d2;
                dArray[i][n + j] = -d2;
            }
        }
        double[] dArray2 = new double[2 * n];
        double[] dArray3 = new double[2 * n];
        LinearMath.reduceSymmetric1_SquareToTridiagonal(dArray, dArray2, dArray3);
        System.arraycopy(dArray3, 1, dArray3, 0, n - 1);
        dArray3[n - 1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray2, dArray3);
        double[] dArray4 = new double[n];
        System.arraycopy(dArray2, 0, dArray4, 0, n);
        return dArray4;
    }

    public static double[] eigenSolveHermitian(AbstractComplexSquareMatrix abstractComplexSquareMatrix, AbstractComplexVector[] abstractComplexVectorArray) throws MaximumIterationsExceededException {
        int n;
        int n2;
        int n3 = abstractComplexSquareMatrix.rows();
        double[][] dArray = new double[2 * n3][2 * n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d = abstractComplexSquareMatrix.getRealElement(n2, n);
                double d2 = abstractComplexSquareMatrix.getImagElement(n2, n);
                dArray[n2][n] = d;
                dArray[n3 + n2][n3 + n] = d;
                dArray[n3 + n2][n] = d2;
                dArray[n2][n3 + n] = -d2;
            }
        }
        double[] dArray2 = new double[2 * n3];
        double[] dArray3 = new double[2 * n3];
        LinearMath.reduceSymmetric2_SquareToTridiagonal(dArray, dArray2, dArray3);
        System.arraycopy(dArray3, 1, dArray3, 0, n3 - 1);
        dArray3[n3 - 1] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(dArray2, dArray3, dArray);
        double[] dArray4 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray4[n2] = dArray2[n2];
            double[] dArray5 = new double[n3];
            double[] dArray6 = new double[n3];
            for (n = 0; n < n3; ++n) {
                dArray5[n] = dArray[n][n2];
                dArray6[n] = dArray[n + n3][n2];
            }
            abstractComplexVectorArray[n2] = new ComplexVector(dArray5, dArray6);
        }
        return dArray4;
    }

    public static double[] eigenvalueSolveSymmetric(DoubleTridiagonalMatrix doubleTridiagonalMatrix) throws MaximumIterationsExceededException {
        int n = doubleTridiagonalMatrix.rows();
        int n2 = n - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = doubleTridiagonalMatrix.getElement(i, i);
            dArray2[i] = doubleTridiagonalMatrix.getElement(i, i + 1);
        }
        dArray[n2] = doubleTridiagonalMatrix.getElement(n2, n2);
        dArray2[n2] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray, dArray2);
        return dArray;
    }

    public static double[] eigenSolveSymmetric(DoubleTridiagonalMatrix doubleTridiagonalMatrix, AbstractDoubleVector[] abstractDoubleVectorArray) throws MaximumIterationsExceededException {
        int n;
        int n2 = doubleTridiagonalMatrix.rows();
        int n3 = n2 - 1;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[][] dArray3 = new double[n2][n2];
        for (n = 0; n < n3; ++n) {
            dArray3[n][n] = 1.0;
            dArray[n] = doubleTridiagonalMatrix.getElement(n, n);
            dArray2[n] = doubleTridiagonalMatrix.getElement(n, n + 1);
        }
        dArray3[n3][n3] = 1.0;
        dArray[n3] = doubleTridiagonalMatrix.getElement(n3, n3);
        dArray2[n3] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(dArray, dArray2, dArray3);
        for (n = 0; n < n2; ++n) {
            DoubleVector doubleVector = new DoubleVector(n2);
            for (int i = 0; i < n2; ++i) {
                doubleVector.setComponent(i, dArray3[i][n]);
            }
            abstractDoubleVectorArray[n] = doubleVector;
        }
        return dArray;
    }

    public static double[] eigenvalueSolveSymmetric(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) throws MaximumIterationsExceededException {
        int n = abstractDoubleSquareMatrix.rows();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[][] dArray3 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[i][j] = abstractDoubleSquareMatrix.getElement(i, j);
            }
        }
        LinearMath.reduceSymmetric1_SquareToTridiagonal(dArray3, dArray, dArray2);
        System.arraycopy(dArray2, 1, dArray2, 0, n - 1);
        dArray2[n - 1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray, dArray2);
        return dArray;
    }

    public static double[] eigenSolveSymmetric(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix, AbstractDoubleVector[] abstractDoubleVectorArray) throws MaximumIterationsExceededException {
        int n;
        int n2;
        int n3 = abstractDoubleSquareMatrix.rows();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray3[n2][n] = abstractDoubleSquareMatrix.getElement(n2, n);
            }
        }
        LinearMath.reduceSymmetric2_SquareToTridiagonal(dArray3, dArray, dArray2);
        System.arraycopy(dArray2, 1, dArray2, 0, n3 - 1);
        dArray2[n3 - 1] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(dArray, dArray2, dArray3);
        for (n2 = 0; n2 < n3; ++n2) {
            DoubleVector doubleVector = new DoubleVector(n3);
            for (n = 0; n < n3; ++n) {
                doubleVector.setComponent(n, dArray3[n][n2]);
            }
            abstractDoubleVectorArray[n2] = doubleVector;
        }
        return dArray;
    }

    public static void diagonalizeSymmetric(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) throws MaximumIterationsExceededException {
        int n = abstractDoubleSquareMatrix.rows();
        double[] dArray = new double[n];
        LinearMath.reduceSymmetric1_SquareToTridiagonal(abstractDoubleSquareMatrix, dArray);
        System.arraycopy(dArray, 1, dArray, 0, n - 1);
        dArray[n - 1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(abstractDoubleSquareMatrix, dArray);
    }

    private static void eigenvalueSolveSymmetricTridiagonalMatrix(double[] dArray, double[] dArray2) throws MaximumIterationsExceededException {
        int n = dArray.length;
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = 0;
            do {
                for (n3 = i; n3 < n2; ++n3) {
                    double d = Math.abs(dArray[n3]) + Math.abs(dArray[n3 + 1]);
                    if (Math.abs(dArray2[n3]) + d == d) break;
                }
                if (n3 == i) continue;
                if (n4++ == EIGEN_MAX_ITERATIONS) {
                    throw new MaximumIterationsExceededException("No convergence after " + EIGEN_MAX_ITERATIONS + " iterations.", dArray);
                }
                double d = (dArray[i + 1] - dArray[i]) / (2.0 * dArray2[i]);
                double d2 = Math.sqrt(d * d + 1.0);
                d = dArray[n3] - dArray[i] + dArray2[i] / (d + (d < 0.0 ? -Math.abs(d2) : Math.abs(d2)));
                double d3 = 1.0;
                double d4 = 1.0;
                double d5 = 0.0;
                for (int j = n3 - 1; j >= i; --j) {
                    double d6 = d4 * dArray2[j];
                    double d7 = d3 * dArray2[j];
                    if (Math.abs(d6) >= Math.abs(d)) {
                        d3 = d / d6;
                        d2 = Math.sqrt(d3 * d3 + 1.0);
                        dArray2[j + 1] = d6 * d2;
                        d4 = 1.0 / d2;
                        d3 *= d4;
                    } else {
                        d4 = d6 / d;
                        d2 = Math.sqrt(d4 * d4 + 1.0);
                        dArray2[j + 1] = d * d2;
                        d3 = 1.0 / d2;
                        d4 *= d3;
                    }
                    d = dArray[j + 1] - d5;
                    d2 = (dArray[j] - d) * d4 + 2.0 * d3 * d7;
                    d5 = d4 * d2;
                    dArray[j + 1] = d + d5;
                    d = d3 * d2 - d7;
                }
                dArray[i] = dArray[i] - d5;
                dArray2[i] = d;
                dArray2[n3] = 0.0;
            } while (n3 != i);
        }
    }

    private static void eigenvalueSolveSymmetricTridiagonalMatrix(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix, double[] dArray) throws MaximumIterationsExceededException {
        int n = abstractDoubleSquareMatrix.rows();
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = 0;
            do {
                for (n3 = i; n3 < n2; ++n3) {
                    double d = Math.abs(abstractDoubleSquareMatrix.getElement(n3, n3)) + Math.abs(abstractDoubleSquareMatrix.getElement(n3 + 1, n3 + 1));
                    if (Math.abs(dArray[n3]) + d == d) break;
                }
                if (n3 == i) continue;
                if (n4++ == EIGEN_MAX_ITERATIONS) {
                    throw new MaximumIterationsExceededException("No convergence after " + EIGEN_MAX_ITERATIONS + " iterations.", abstractDoubleSquareMatrix);
                }
                double d = (abstractDoubleSquareMatrix.getElement(i + 1, i + 1) - abstractDoubleSquareMatrix.getElement(i, i)) / (2.0 * dArray[i]);
                double d2 = Math.sqrt(d * d + 1.0);
                d = abstractDoubleSquareMatrix.getElement(n3, n3) - abstractDoubleSquareMatrix.getElement(i, i) + dArray[i] / (d + (d < 0.0 ? -Math.abs(d2) : Math.abs(d2)));
                double d3 = 1.0;
                double d4 = 1.0;
                double d5 = 0.0;
                for (int j = n3 - 1; j >= i; --j) {
                    double d6 = d4 * dArray[j];
                    double d7 = d3 * dArray[j];
                    if (Math.abs(d6) >= Math.abs(d)) {
                        d3 = d / d6;
                        d2 = Math.sqrt(d3 * d3 + 1.0);
                        dArray[j + 1] = d6 * d2;
                        d4 = 1.0 / d2;
                        d3 *= d4;
                    } else {
                        d4 = d6 / d;
                        d2 = Math.sqrt(d4 * d4 + 1.0);
                        dArray[j + 1] = d * d2;
                        d3 = 1.0 / d2;
                        d4 *= d3;
                    }
                    d = abstractDoubleSquareMatrix.getElement(j + 1, j + 1) - d5;
                    d2 = (abstractDoubleSquareMatrix.getElement(j, j) - d) * d4 + 2.0 * d3 * d7;
                    d5 = d4 * d2;
                    abstractDoubleSquareMatrix.setElement(j + 1, j + 1, d + d5);
                    d = d3 * d2 - d7;
                }
                abstractDoubleSquareMatrix.setElement(i, i, abstractDoubleSquareMatrix.getElement(i, i) - d5);
                dArray[i] = d;
                dArray[n3] = 0.0;
            } while (n3 != i);
        }
    }

    private static void reduceSymmetric1_SquareToTridiagonal(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2 = dArray2.length;
        for (n = n2 - 1; n > 0; --n) {
            int n3 = n - 1;
            double d = 0.0;
            double d2 = 0.0;
            if (n3 > 0) {
                int n4;
                for (n4 = 0; n4 <= n3; ++n4) {
                    d += Math.abs(dArray[n][n4]);
                }
                if (d == 0.0) {
                    dArray3[n] = dArray[n][n3];
                    continue;
                }
                for (n4 = 0; n4 <= n3; ++n4) {
                    double d3;
                    dArray[n][n4] = d3 = dArray[n][n4] / d;
                    d2 += d3 * d3;
                }
                double d4 = dArray[n][n3];
                double d5 = d4 >= 0.0 ? -Math.sqrt(d2) : Math.sqrt(d2);
                dArray3[n] = d * d5;
                d2 -= d4 * d5;
                dArray[n][n3] = d4 - d5;
                d4 = 0.0;
                for (n4 = 0; n4 <= n3; ++n4) {
                    int n5;
                    d5 = 0.0;
                    for (n5 = 0; n5 <= n4; ++n5) {
                        d5 += dArray[n4][n5] * dArray[n][n5];
                    }
                    for (n5 = n4 + 1; n5 <= n3; ++n5) {
                        d5 += dArray[n5][n4] * dArray[n][n5];
                    }
                    dArray3[n4] = d5 / d2;
                    d4 += dArray3[n4] * dArray[n][n4];
                }
                double d6 = d4 / (d2 + d2);
                for (int i = 0; i <= n3; ++i) {
                    d4 = dArray[n][i];
                    dArray3[i] = d5 = dArray3[i] - d6 * d4;
                    for (int j = 0; j <= i; ++j) {
                        double[] dArray4 = dArray[i];
                        int n6 = j;
                        dArray4[n6] = dArray4[n6] - (d4 * dArray3[j] + d5 * dArray[n][j]);
                    }
                }
                continue;
            }
            dArray3[n] = dArray[n][n3];
        }
        dArray3[0] = 0.0;
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray[n][n];
        }
    }

    private static void reduceSymmetric1_SquareToTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix, double[] dArray) {
        int n = abstractDoubleSquareMatrix.rows();
        for (int i = n - 1; i > 0; --i) {
            int n2 = i - 1;
            double d = 0.0;
            double d2 = 0.0;
            if (n2 > 0) {
                int n3;
                for (n3 = 0; n3 <= n2; ++n3) {
                    d += Math.abs(abstractDoubleSquareMatrix.getElement(i, n3));
                }
                if (d == 0.0) {
                    dArray[i] = abstractDoubleSquareMatrix.getElement(i, n2);
                    continue;
                }
                for (n3 = 0; n3 <= n2; ++n3) {
                    double d3 = abstractDoubleSquareMatrix.getElement(i, n3) / d;
                    abstractDoubleSquareMatrix.setElement(i, n3, d3);
                    d2 += d3 * d3;
                }
                double d4 = abstractDoubleSquareMatrix.getElement(i, n2);
                double d5 = d4 >= 0.0 ? -Math.sqrt(d2) : Math.sqrt(d2);
                dArray[i] = d * d5;
                d2 -= d4 * d5;
                abstractDoubleSquareMatrix.setElement(i, n2, d4 - d5);
                d4 = 0.0;
                for (n3 = 0; n3 <= n2; ++n3) {
                    int n4;
                    d5 = 0.0;
                    for (n4 = 0; n4 <= n3; ++n4) {
                        d5 += abstractDoubleSquareMatrix.getElement(n3, n4) * abstractDoubleSquareMatrix.getElement(i, n4);
                    }
                    for (n4 = n3 + 1; n4 <= n2; ++n4) {
                        d5 += abstractDoubleSquareMatrix.getElement(n4, n3) * abstractDoubleSquareMatrix.getElement(i, n4);
                    }
                    dArray[n3] = d5 / d2;
                    d4 += dArray[n3] * abstractDoubleSquareMatrix.getElement(i, n3);
                }
                double d6 = d4 / (d2 + d2);
                for (int j = 0; j <= n2; ++j) {
                    d4 = abstractDoubleSquareMatrix.getElement(i, j);
                    dArray[j] = d5 = dArray[j] - d6 * d4;
                    for (int k = 0; k <= j; ++k) {
                        abstractDoubleSquareMatrix.setElement(j, k, abstractDoubleSquareMatrix.getElement(j, k) - d4 * dArray[k] - d5 * abstractDoubleSquareMatrix.getElement(i, k));
                    }
                }
                continue;
            }
            dArray[i] = abstractDoubleSquareMatrix.getElement(i, n2);
        }
        dArray[0] = 0.0;
    }

    private static void eigenSolveSymmetricTridiagonalMatrix(double[] dArray, double[] dArray2, double[][] dArray3) throws MaximumIterationsExceededException {
        int n = dArray.length;
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = 0;
            do {
                for (n3 = i; n3 < n2; ++n3) {
                    double d = Math.abs(dArray[n3]) + Math.abs(dArray[n3 + 1]);
                    if (Math.abs(dArray2[n3]) + d == d) break;
                }
                if (n3 == i) continue;
                if (n4++ == EIGEN_MAX_ITERATIONS) {
                    throw new MaximumIterationsExceededException("No convergence after " + EIGEN_MAX_ITERATIONS + " iterations.", new Object[]{dArray, dArray3});
                }
                double d = (dArray[i + 1] - dArray[i]) / (2.0 * dArray2[i]);
                double d2 = Math.sqrt(d * d + 1.0);
                d = dArray[n3] - dArray[i] + dArray2[i] / (d + (d < 0.0 ? -Math.abs(d2) : Math.abs(d2)));
                double d3 = 1.0;
                double d4 = 1.0;
                double d5 = 0.0;
                for (int j = n3 - 1; j >= i; --j) {
                    double d6 = d4 * dArray2[j];
                    double d7 = d3 * dArray2[j];
                    if (Math.abs(d6) >= Math.abs(d)) {
                        d3 = d / d6;
                        d2 = Math.sqrt(d3 * d3 + 1.0);
                        dArray2[j + 1] = d6 * d2;
                        d4 = 1.0 / d2;
                        d3 *= d4;
                    } else {
                        d4 = d6 / d;
                        d2 = Math.sqrt(d4 * d4 + 1.0);
                        dArray2[j + 1] = d * d2;
                        d3 = 1.0 / d2;
                        d4 *= d3;
                    }
                    d = dArray[j + 1] - d5;
                    d2 = (dArray[j] - d) * d4 + 2.0 * d3 * d7;
                    d5 = d4 * d2;
                    dArray[j + 1] = d + d5;
                    d = d3 * d2 - d7;
                    for (int k = 0; k < n; ++k) {
                        d6 = dArray3[k][j + 1];
                        dArray3[k][j + 1] = d4 * dArray3[k][j] + d3 * d6;
                        dArray3[k][j] = d3 * dArray3[k][j] - d4 * d6;
                    }
                }
                dArray[i] = dArray[i] - d5;
                dArray2[i] = d;
                dArray2[n3] = 0.0;
            } while (n3 != i);
        }
    }

    private static void reduceSymmetric2_SquareToTridiagonal(double[][] dArray, double[] dArray2, double[] dArray3) {
        double d;
        int n;
        int n2;
        int n3;
        int n4 = dArray2.length;
        for (n3 = n4 - 1; n3 > 0; --n3) {
            n2 = n3 - 1;
            double d2 = 0.0;
            double d3 = 0.0;
            if (n2 > 0) {
                for (n = 0; n <= n2; ++n) {
                    d2 += Math.abs(dArray[n3][n]);
                }
                if (d2 == 0.0) {
                    dArray3[n3] = dArray[n3][n2];
                } else {
                    for (n = 0; n <= n2; ++n) {
                        double d4;
                        dArray[n3][n] = d4 = dArray[n3][n] / d2;
                        d3 += d4 * d4;
                    }
                    double d5 = dArray[n3][n2];
                    d = d5 >= 0.0 ? -Math.sqrt(d3) : Math.sqrt(d3);
                    dArray3[n3] = d2 * d;
                    d3 -= d5 * d;
                    dArray[n3][n2] = d5 - d;
                    d5 = 0.0;
                    for (n = 0; n <= n2; ++n) {
                        int n5;
                        dArray[n][n3] = dArray[n3][n] / d3;
                        d = 0.0;
                        for (n5 = 0; n5 <= n; ++n5) {
                            d += dArray[n][n5] * dArray[n3][n5];
                        }
                        for (n5 = n + 1; n5 <= n2; ++n5) {
                            d += dArray[n5][n] * dArray[n3][n5];
                        }
                        dArray3[n] = d / d3;
                        d5 += dArray3[n] * dArray[n3][n];
                    }
                    double d6 = d5 / (d3 + d3);
                    for (int i = 0; i <= n2; ++i) {
                        d5 = dArray[n3][i];
                        dArray3[i] = d = dArray3[i] - d6 * d5;
                        for (int j = 0; j <= i; ++j) {
                            double[] dArray4 = dArray[i];
                            int n6 = j;
                            dArray4[n6] = dArray4[n6] - (d5 * dArray3[j] + d * dArray[n3][j]);
                        }
                    }
                }
            } else {
                dArray3[n3] = dArray[n3][n2];
            }
            dArray2[n3] = d3;
        }
        dArray3[0] = 0.0;
        dArray2[0] = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = n3 - 1;
            if (dArray2[n3] != 0.0) {
                for (n = 0; n <= n2; ++n) {
                    int n7;
                    d = 0.0;
                    for (n7 = 0; n7 <= n2; ++n7) {
                        d += dArray[n3][n7] * dArray[n7][n];
                    }
                    for (n7 = 0; n7 <= n2; ++n7) {
                        double[] dArray5 = dArray[n7];
                        int n8 = n;
                        dArray5[n8] = dArray5[n8] - d * dArray[n7][n3];
                    }
                }
            }
            dArray2[n3] = dArray[n3][n3];
            dArray[n3][n3] = 1.0;
            for (n = 0; n <= n2; ++n) {
                dArray[n3][n] = 0.0;
                dArray[n][n3] = 0.0;
            }
        }
    }

    public static double[] eigenvalueSolveSymmetric(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix, AbstractDoubleVector abstractDoubleVector, int n) throws MaximumIterationsExceededException {
        AbstractDoubleVector[] abstractDoubleVectorArray = new AbstractDoubleVector[n];
        abstractDoubleVectorArray[0] = abstractDoubleVector;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            AbstractDoubleVector abstractDoubleVector2 = abstractDoubleSquareMatrix.multiply(abstractDoubleVectorArray[i]);
            if (i > 0) {
                abstractDoubleVector2 = abstractDoubleVector2.subtract(abstractDoubleVectorArray[i - 1].scalarMultiply(dArray2[i - 1]));
            }
            dArray[i] = abstractDoubleVector2.scalarProduct(abstractDoubleVectorArray[i]);
            abstractDoubleVector2 = abstractDoubleVector2.subtract(abstractDoubleVectorArray[i].scalarMultiply(dArray[i]));
            abstractDoubleVector2 = LinearMath.gramSchmidtReorthogonalize(abstractDoubleVector2, abstractDoubleVectorArray, i);
            dArray2[i] = abstractDoubleVector2.norm();
            if (i >= n - 1) continue;
            abstractDoubleVectorArray[i + 1] = abstractDoubleVector2.scalarDivide(dArray2[i]);
        }
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray, dArray2);
        return dArray;
    }

    private static AbstractDoubleVector gramSchmidtReorthogonalize(AbstractDoubleVector abstractDoubleVector, AbstractDoubleVector[] abstractDoubleVectorArray, int n) {
        for (int i = 0; i < n; ++i) {
            abstractDoubleVector = abstractDoubleVector.subtract(abstractDoubleVectorArray[i].scalarMultiply(abstractDoubleVectorArray[i].scalarProduct(abstractDoubleVector)));
        }
        return abstractDoubleVector;
    }
}

