/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.Complex;
import JSci.maths.chaos.MandelbrotMap;

public final class JuliaSet {
    public static final Complex RABBIT = new Complex(-0.123, 0.745);
    public static final Complex SAN_MARCO = new Complex(-0.75, 0.0);
    public static final Complex SIEGEL_DISK = new Complex(-0.391, -0.587);
    private final MandelbrotMap mbrot;

    public JuliaSet(Complex complex) {
        this.mbrot = new MandelbrotMap(complex);
    }

    public int isMember(Complex complex, int n) {
        for (int i = 0; i < n; ++i) {
            if (!((complex = this.mbrot.map(complex)).mod() > 2.0)) continue;
            return i + 1;
        }
        return 0;
    }

    public int isMember(double d, double d2, int n) {
        double d3 = this.mbrot.getConstant().real();
        double d4 = this.mbrot.getConstant().imag();
        for (int i = 0; i < n; ++i) {
            double d5 = 2.0 * d * d2 + d4;
            if (!((d = d * d - d2 * d2 + d3) * d + (d2 = d5) * d2 > 4.0)) continue;
            return i + 1;
        }
        return 0;
    }
}

