/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.symbolic;

import JSci.maths.MathDouble;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.symbolic.Constant;
import JSci.maths.symbolic.Expression;
import JSci.maths.symbolic.Product;
import JSci.maths.symbolic.Variable;

class Power
extends Expression {
    private final Expression base;
    private final int exponent;

    public Power(Expression expression, int n) {
        this.base = expression;
        this.exponent = n;
    }

    public Expression getBase() {
        return this.base;
    }

    public int getExponent() {
        return this.exponent;
    }

    public String toString() {
        String string = "";
        string = this.base.getPriority() < this.getPriority() ? string + "(" + this.base + ")" : string + "" + this.base;
        string = string + "^";
        int n = this.exponent >= 0 ? 20 : 0;
        string = n < this.getPriority() ? string + "(" + this.exponent + ")" : string + "" + this.exponent;
        return string;
    }

    public Expression differentiate(Variable variable) {
        return new Product(new Expression[]{new Constant(new MathDouble(this.exponent)), new Power(this.base, this.exponent - 1), this.base.differentiate(variable)});
    }

    public Expression evaluate() {
        Expression expression = this.base.evaluate();
        if (expression instanceof Constant) {
            Field.Member member = (Field.Member)((Ring)((Constant)expression).getValue().getSet()).one();
            if (this.exponent >= 0) {
                Ring.Member member2 = (Ring.Member)((Constant)expression).getValue();
                for (int i = 0; i < this.exponent; ++i) {
                    member = (Field.Member)member.multiply((Field.Member)member2);
                }
            } else {
                Field.Member member3 = (Field.Member)((Constant)expression).getValue();
                member3 = member3.inverse();
                for (int i = 0; i < -this.exponent; ++i) {
                    member = (Field.Member)member.multiply(member3);
                }
            }
            return new Constant(member);
        }
        if (this.exponent == 0) {
            return new Constant(((Ring)this.base.getSet()).one());
        }
        if (this.exponent == 1) {
            return this.base;
        }
        return new Power(expression, this.exponent);
    }

    protected int getPriority() {
        return 15;
    }

    public Object getSet() {
        return this.base.getSet();
    }
}

