/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiMuon;
import JSci.physics.particles.Lepton;
import JSci.physics.particles.MuonNeutrino;
import JSci.physics.particles.Photon;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class Muon
extends Lepton {
    public double restMass() {
        return 105.658357;
    }

    public int charge() {
        return -1;
    }

    public int eLeptonQN() {
        return 0;
    }

    public int muLeptonQN() {
        return 1;
    }

    public int tauLeptonQN() {
        return 0;
    }

    public QuantumParticle anti() {
        return new AntiMuon();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof AntiMuon;
    }

    public String toString() {
        return new String("Muon");
    }

    public Muon emit(Photon photon) {
        this.momentum = this.momentum.subtract(photon.momentum);
        return this;
    }

    public Muon absorb(Photon photon) {
        this.momentum = this.momentum.add(photon.momentum);
        return this;
    }

    public MuonNeutrino emit(WMinus wMinus) {
        MuonNeutrino muonNeutrino = new MuonNeutrino();
        muonNeutrino.momentum = this.momentum.subtract(wMinus.momentum);
        return muonNeutrino;
    }

    public MuonNeutrino emit(WPlus wPlus) {
        MuonNeutrino muonNeutrino = new MuonNeutrino();
        muonNeutrino.momentum = this.momentum.add(wPlus.momentum);
        return muonNeutrino;
    }

    public Muon emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public Muon absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

