/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.net.UnknownHostException;
import javax.swing.JOptionPane;
import org.forester.analysis.AncestralTaxonomyInference;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.RunnableProcess;
import org.forester.phylogeny.Phylogeny;

public class AncestralTaxonomyInferrer
extends RunnableProcess {
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;

    public AncestralTaxonomyInferrer(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
    }

    public static String getBaseUrl() {
        return "http://www.uniprot.org/";
    }

    private void inferTaxonomies() {
        this.start(this._mf, "ancestral taxonomy");
        try {
            AncestralTaxonomyInference.inferTaxonomyFromDescendents(this._phy);
        }
        catch (AncestralTaxonomyInferenceException ancestralTaxonomyInferenceException) {
            this.end(this._mf);
            JOptionPane.showMessageDialog(this._mf, ancestralTaxonomyInferenceException.getMessage(), "Error during ancestral taxonomy inference", 0);
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this.end(this._mf);
            JOptionPane.showMessageDialog(this._mf, "Could not connect to \"" + AncestralTaxonomyInferrer.getBaseUrl() + "\"", "Network error during ancestral taxonomy inference", 0);
            return;
        }
        catch (Exception exception) {
            this.end(this._mf);
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, exception.toString(), "Unexpected exception during ancestral taxonomy inference", 0);
            return;
        }
        catch (Error error) {
            this.end(this._mf);
            JOptionPane.showMessageDialog(this._mf, error.toString(), "Unexpected error during ancestral taxonomy inference", 0);
            return;
        }
        this._phy.setRerootable(false);
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        this.end(this._mf);
        try {
            JOptionPane.showMessageDialog(this._mf, "Ancestral taxonomy inference successfully completed", "Ancestral Taxonomy Inference Completed", 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.inferTaxonomies();
    }
}

