/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.RunnableProcess;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public class GoAnnotation
extends RunnableProcess {
    private static final String SYMBOL = "Symbol";
    private static final String ASPECT = "Aspect";
    private static final String DB = "DB";
    private static final String EVIDENCE = "Evidence";
    private static final String GO_NAME = "GO Name";
    private static final String GO_ID = "GO ID";
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;

    public GoAnnotation(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
    }

    private void annotate() {
        this.start(this._mf, "GO annotate");
        PhylogenyNodeIterator phylogenyNodeIterator = this._phy.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().getSequences() == null || phylogenyNode.getNodeData().getSequences().isEmpty()) continue;
            for (Sequence sequence : phylogenyNode.getNodeData().getSequences()) {
                if ((sequence.getAccession() == null || ForesterUtil.isEmpty(sequence.getAccession().getValue()) || sequence.getAnnotations() != null) && !sequence.getAnnotations().isEmpty()) continue;
                Accession accession = sequence.getAccession();
                try {
                    String string;
                    URL uRL = new URL("http://www.ebi.ac.uk/QuickGO/GAnnotation?protein=" + accession.getValue() + "&format=tsv");
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    List<String> list = Arrays.asList(bufferedReader.readLine().split("\t"));
                    System.out.println(list);
                    int n = list.indexOf(DB);
                    int n2 = list.indexOf(GO_ID);
                    int n3 = list.indexOf(GO_NAME);
                    int n4 = list.indexOf(EVIDENCE);
                    int n5 = list.indexOf("Taxon");
                    int n6 = list.indexOf("Qualifier");
                    int n7 = list.indexOf("Reference");
                    int n8 = list.indexOf(SYMBOL);
                    int n9 = list.indexOf("Splice");
                    int n10 = list.indexOf("With");
                    int n11 = list.indexOf(ASPECT);
                    int n12 = list.indexOf("Source");
                    while ((string = bufferedReader.readLine()) != null) {
                        String[] stringArray = string.split("\t");
                        Annotation annotation = new Annotation(stringArray[n2]);
                        annotation.setDesc(n3 >= 0 ? stringArray[n3] : "");
                        annotation.setSource(n >= 0 ? stringArray[n] : "");
                        annotation.setEvidence(n4 >= 0 ? stringArray[n4] : "");
                        annotation.setType(n11 >= 0 ? stringArray[n11] : "");
                        sequence.addAnnotation(annotation);
                        if (ForesterUtil.isEmpty(sequence.getSymbol()) && n8 >= 0 && !ForesterUtil.isEmpty(stringArray[n8])) {
                            sequence.setSymbol(stringArray[n8]);
                        }
                        System.out.println("DB: " + stringArray[n]);
                        System.out.println("GO ID: " + stringArray[n2]);
                        System.out.println("GO Name: " + stringArray[n3]);
                        System.out.println("Evidence: " + stringArray[n4]);
                        System.out.println(" taxon: " + stringArray[n5]);
                        System.out.println(" qualifier: " + stringArray[n6]);
                        System.out.println(" reference: " + stringArray[n7]);
                        System.out.println("Symbol: " + stringArray[n8]);
                        System.out.println(" splice: " + stringArray[n9]);
                        System.out.println(" with: " + stringArray[n10]);
                        System.out.println("Aspect: " + stringArray[n11]);
                        System.out.println(" source: " + stringArray[n12]);
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this.end(this._mf);
        this._treepanel.repaint();
        this._treepanel.setEdited(true);
    }

    @Override
    public void run() {
        this.annotate();
    }
}

