/*
 * Decompiled with CFR 0.152.
 */
package binc;

import binc.GlobalSettings;
import binc.installer.Installer;
import binc.lookup.BinLookupStrategy;
import binc.lookup.DirectoryListLookup;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Command {
    private final String name;
    private final List<Installer> installers;
    private final List<String> args;
    private final File workingDirectory;
    private final long maxDelay;
    private final File outputFile;
    private final ResultCodeInterpreter resultCodeInterpreter;
    private final List<? extends BinLookupStrategy> strategies;
    private final boolean standardOutMirroring;

    public static Command cmd(File cmdLocation) {
        return Command.cmd(cmdLocation.getName()).setLookupStrategy(DirectoryListLookup.fromListWithUserHomeToResolve(Collections.singletonList(cmdLocation.getParent())));
    }

    public static Command byName(String name) {
        return Command.cmd(name);
    }

    public static Command byPath(File path) {
        return Command.cmd(path);
    }

    public static Command cmd(String name) {
        if (name.contains("/")) {
            return Command.cmd(new File(name));
        }
        return new Command(name, new ArrayList<Installer>(), new ArrayList<String>(), null, Long.MAX_VALUE, null, new DefaultResultCodeInterpreter(), GlobalSettings.defaultLookupStrategies, false);
    }

    public File which() {
        return this.lookup();
    }

    public Command setInstaller(Installer _installer) {
        ArrayList installers = Lists.newArrayList();
        installers.add(_installer);
        return new Command(this.name, installers, this.args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command setInstallers(List<Installer> _installers) {
        List<Installer> installers = _installers;
        return new Command(this.name, installers, this.args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command setLookupStrategies(List<? extends BinLookupStrategy> _strategies) {
        List<? extends BinLookupStrategy> strategies = _strategies;
        return new Command(this.name, this.installers, this.args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, strategies, this.standardOutMirroring);
    }

    public Command setLookupStrategy(BinLookupStrategy _strategy) {
        ArrayList<BinLookupStrategy> strategies = new ArrayList<BinLookupStrategy>();
        strategies.add(_strategy);
        return new Command(this.name, this.installers, this.args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, strategies, this.standardOutMirroring);
    }

    private static List<String> split(String args) {
        String[] splitArgs = args == null || args.matches("^\\s*$") ? new String[]{} : args.split("\\s+");
        return Arrays.asList(splitArgs);
    }

    public Command withArgs(String _args) {
        List<String> args = Command.split(_args);
        return new Command(this.name, this.installers, args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command withSegmentedArguments(List<String> _args) {
        List<String> args = _args;
        return new Command(this.name, this.installers, args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command withArg(String _arg) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{_arg});
        return new Command(this.name, this.installers, args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command appendArgs(String _args) {
        ArrayList args = Lists.newArrayList(this.args);
        args.addAll(Command.split(_args));
        return new Command(this.name, this.installers, args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command appendArg(String _arg) {
        ArrayList args = Lists.newArrayList(this.args);
        args.add(_arg);
        return new Command(this.name, this.installers, args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command ranIn(File _workingDirectory) {
        File workingDirectory = _workingDirectory;
        return new Command(this.name, this.installers, this.args, workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command setMaxDelay(long _maxDelay) {
        long maxDelay = _maxDelay;
        return new Command(this.name, this.installers, this.args, this.workingDirectory, maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command saveOutputTo(File _outputFile) {
        File outputFile = _outputFile;
        return new Command(this.name, this.installers, this.args, this.workingDirectory, this.maxDelay, outputFile, this.resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command withStandardOutMirroring() {
        boolean standardOutMirroring = true;
        return new Command(this.name, this.installers, this.args, this.workingDirectory, this.maxDelay, this.outputFile, this.resultCodeInterpreter, this.strategies, standardOutMirroring);
    }

    public Command throwOnNonZeroReturnCode() {
        ThrowOnNonZeroCode resultCodeInterpreter = new ThrowOnNonZeroCode();
        return new Command(this.name, this.installers, this.args, this.workingDirectory, this.maxDelay, this.outputFile, resultCodeInterpreter, this.strategies, this.standardOutMirroring);
    }

    public Command(String name, List<Installer> installers, List<String> args, File workingDirectory, long maxDelay, File outputFile, ResultCodeInterpreter resultCodeInterpreter, List<? extends BinLookupStrategy> strategies, boolean standardOutMirroring) {
        this.name = name;
        this.installers = installers;
        this.args = args;
        this.workingDirectory = workingDirectory;
        this.maxDelay = maxDelay;
        this.outputFile = outputFile;
        this.resultCodeInterpreter = resultCodeInterpreter;
        this.strategies = strategies;
        this.standardOutMirroring = standardOutMirroring;
    }

    public ProcessBuilder newProcessBuilder() {
        List<String> command = this.buildCommand();
        ProcessBuilder pb = new ProcessBuilder(command);
        if (this.workingDirectory != null) {
            pb.directory(this.workingDirectory);
        }
        pb.redirectErrorStream(true);
        return pb;
    }

    public static String call(Command cmd) {
        return cmd.call();
    }

    public String call() {
        return this.callWithInputStreamContents("");
    }

    public String callWithInputStreamContents(String inputStreamContents) {
        ProcessBuilder pb = this.newProcessBuilder();
        Process _proc = null;
        StringBuilder result = new StringBuilder();
        PrintWriter writer = null;
        try {
            Process proc;
            writer = this.outputFile == null ? null : new PrintWriter(this.outputFile, "UTF-8");
            _proc = proc = pb.start();
            Timer timer = new Timer();
            if (this.maxDelay != Long.MAX_VALUE) {
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.err.println("Command " + Command.this.name + " timed out (max time was " + Command.this.maxDelay + "ms)");
                        proc.destroy();
                    }
                }, this.maxDelay);
            }
            InputStream stdout = proc.getInputStream();
            InputStreamReader stdoutReader = new InputStreamReader(stdout);
            BufferedReader stdoutBufferedReader = new BufferedReader(stdoutReader);
            String line = null;
            OutputStream stdin = proc.getOutputStream();
            PrintWriter pw = new PrintWriter(stdin);
            pw.append(inputStreamContents);
            pw.close();
            while ((line = stdoutBufferedReader.readLine()) != null) {
                result.append(line + "\n");
                if (writer != null) {
                    writer.append(line + "\n");
                }
                if (!this.standardOutMirroring) continue;
                System.out.println(line);
            }
            int resultCode = proc.waitFor();
            this.resultCodeInterpreter.interpret(this, resultCode, result);
            timer.cancel();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            if (_proc != null) {
                try {
                    _proc.getErrorStream().close();
                    _proc.getInputStream().close();
                    _proc.getOutputStream().close();
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result.toString();
    }

    private List<String> buildCommand() {
        File binaryLocation = this.lookup();
        if (binaryLocation == null) {
            throw new RuntimeException("Binary not found: " + this.name + "\nLookup strategies: " + this.strategies + "\nCurrent directory: " + this.workingDirectory);
        }
        ArrayList command = Lists.newArrayList();
        command.add(binaryLocation.getAbsolutePath());
        command.addAll(this.args);
        return command;
    }

    public File lookup() {
        for (BinLookupStrategy binLookupStrategy : this.strategies) {
            File result = binLookupStrategy.lookup(this);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<Installer> getInstallers() {
        return this.installers;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public static class ThrowOnNonZeroCode
    implements ResultCodeInterpreter {
        @Override
        public void interpret(Command c, int code, CharSequence output) {
            if (code != 0) {
                throw new RuntimeException("Warning: command " + c.name + " returned non-zero code (" + code + "). Output so far:\n" + output);
            }
        }
    }

    public static class DefaultResultCodeInterpreter
    implements ResultCodeInterpreter {
        @Override
        public void interpret(Command c, int code, CharSequence output) {
            if (code != 0) {
                System.err.println("Warning: command " + c.name + " returned non-zero code (" + code + "). Output so far:\n" + output);
            }
        }
    }

    public static interface ResultCodeInterpreter {
        public void interpret(Command var1, int var2, CharSequence var3);
    }
}

