/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Arrays;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sdi.SDI;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIR;
import org.forester.sdi.SDIse;
import org.forester.util.ForesterUtil;

public class sdi_dir {
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org";
    private static final String PRG_NAME = "sdi_dir";
    private static final String PRG_VERSION = "2.00";
    private static final String PRG_DATE = "2010.04.26";

    private static void errorInCommandLine() {
        System.out.println("\nsdi_dir: Error in command line.\n");
        System.out.print("Usage: % sdi_dir [-options] <gene tree directory> <suffix for gene trees>");
        System.out.println(" <species tree file name> <output directory> <outputfile name>");
        System.out.println("\nOptions:");
        System.out.println(" -l to root by minimizing the mapping cost L (and also the sum of duplications)");
        System.out.println(" -d to root by minimizing the sum of duplications");
        System.out.println(" -h to root by minimizing tree height (can be used together with -l or -d)");
        System.out.println(" -w to write assigned gene trees into output directory");
        System.out.println("\nGene tree directory");
        System.out.println(" The directory from which to read phyloXML formatted gene trees which");
        System.out.println(" contain taxonomic information in appropriate sub-elements of taxonomy");
        System.out.println(" (see: www.phyloxml.org).");
        System.out.println(" The gene trees can either be rooted, in which case no rooting with -l, -d, or -h ");
        System.out.println(" is necessary, or they can be unrooted, in which case rooting is mandatory.");
        System.out.println("\nSuffix for gene trees");
        System.out.println(" Suffix of the gene trees to analyze (e.g. \".phyloxml\").");
        System.out.println("\nSpecies tree file");
        System.out.println(" In phyloXML format, taxonomic information in appropriate sub-elements of taxonomy.");
        System.out.println(" (see: www.phyloxml.org).");
        System.out.println("\nOutput directory");
        System.out.println(" The directory into which the assigned gene trees will be written.");
        System.out.println("\nOutputfile name");
        System.out.println(" File name for summary output files.");
        System.out.println("");
        System.exit(-1);
    }

    public static void infer(File file, File file2, File file3, File file4, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, SDIException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        Phylogeny phylogeny = null;
        Object object = null;
        Object[] objectArray = null;
        Phylogeny[] phylogenyArray = null;
        int[] nArray = new int[4999];
        int[] nArray2 = new int[4999];
        File file5 = null;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        PrintWriter printWriter3 = null;
        File file6 = new File(file4 + "_Ddist");
        File file7 = new File(file4 + "_Sdist");
        DecimalFormat decimalFormat = new DecimalFormat("0.0#####");
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException(file + " does not exist or is not a directory.");
        }
        if (!file3.exists() || !file3.isDirectory()) {
            throw new IllegalArgumentException(file3 + " does not exist or is not a directory.");
        }
        if (file4.exists()) {
            throw new IllegalArgumentException(file4 + " does already exist.");
        }
        if (file6.exists()) {
            throw new IllegalArgumentException(file6 + " does already exist.");
        }
        if (file7.exists()) {
            throw new IllegalArgumentException(file7 + " does already exist.");
        }
        if (!file2.exists() || !file2.isFile()) {
            throw new IllegalArgumentException(file2 + " does not exist or is not a file.");
        }
        if (bl2 && bl3) {
            bl3 = false;
        }
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        phylogeny = phylogenyFactory.create(file2, new PhyloXmlParser())[0];
        objectArray = file.list();
        Arrays.sort(objectArray);
        string = string.trim();
        printWriter = new PrintWriter((Writer)new FileWriter(file4), true);
        for (n = 0; n < objectArray.length; ++n) {
            Object object2;
            File file8;
            object = objectArray[n];
            if (string.length() >= 1 && !((String)object).endsWith(string) || !(file8 = new File(file.getPath(), (String)object)).exists() || !file8.isFile()) continue;
            printWriter.print(n9 + "\t" + (String)object);
            System.out.println(n9 + ": " + (String)object);
            ++n9;
            Phylogeny phylogeny2 = null;
            phylogeny2 = phylogenyFactory.create(file8, new PhyloXmlParser())[0];
            n8 = PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogeny, phylogeny2);
            if (((String)object).length() < 8) {
                printWriter.print("\t\t\t[-" + n8 + "]");
            } else if (((String)object).length() < 16) {
                printWriter.print("\t\t[-" + n8 + "]");
            } else {
                printWriter.print("\t[-" + n8 + "]");
            }
            if (phylogeny2.getNumberOfExternalNodes() < 4) {
                printWriter.print("\t<4en\n");
                ++n3;
                continue;
            }
            if (phylogeny2.getNumberOfExternalNodes() > 5000) {
                printWriter.print("\t>5000en\n");
                ++n4;
                continue;
            }
            SDIR sDIR = null;
            sDIR = new SDIR();
            if (bl2 || bl3 || bl4) {
                phylogenyArray = sDIR.infer(phylogeny2, phylogeny, bl2, bl3, bl4, bl, 1);
                n5 = sDIR.getMinimalDuplications();
            } else {
                object2 = new SDIse(phylogeny2, phylogeny);
                phylogenyArray = new Phylogeny[]{phylogeny2};
                n5 = ((SDI)object2).getDuplicationsSum();
                n6 = ((SDI)object2).computeMappingCostL();
                l3 += (long)n6;
                printWriter.print("\t L=" + n6);
            }
            ++n2;
            n7 = phylogeny2.getNumberOfExternalNodes();
            l2 += (long)n7;
            int n10 = n7;
            nArray2[n10] = nArray2[n10] + 1;
            printWriter.print("\t " + n7 + "en");
            l += (long)n5;
            int n11 = n5;
            nArray[n11] = nArray[n11] + 1;
            printWriter.print("\t " + n5 + "d");
            if (bl2) {
                n6 = sDIR.getMinimalMappingCost();
                l3 += (long)n6;
                printWriter.print("\t L=" + n6);
            }
            if (bl4) {
                printWriter.print("\t h=" + decimalFormat.format(sDIR.getMinimalTreeHeight()));
                printWriter.print("\t d=" + decimalFormat.format(sDIR.getMinimalDiffInSubTreeHeights()));
                d += sDIR.getMinimalTreeHeight();
                d2 += sDIR.getMinimalDiffInSubTreeHeights();
            }
            printWriter.println();
            if (!bl) continue;
            file5 = new File(file3, new File((String)objectArray[n]).getName());
            object2 = new PhylogenyWriter();
            ((PhylogenyWriter)object2).toPhyloXML(file5, phylogenyArray[0], 1);
        }
        if (bl2) {
            printWriter.println("\nRooted by minimizing mapping cost L.");
            System.out.println("\nRooted by minimizing mapping cost L.");
            if (bl4) {
                printWriter.println("Selected tree(s) with minimal height out of resulting trees.");
                System.out.println("Selected tree(s) with minimal height out of resulting trees.");
            }
        } else if (bl3) {
            printWriter.println("\nRooted by minimizing sum of duplications.");
            System.out.println("\nRooted by minimizing sum of duplications.");
            if (bl4) {
                printWriter.println("Selected tree(s) with minimal height out of resulting trees.");
                System.out.println("Selected tree(s) with minimal height out of resulting trees.");
            }
        } else if (bl4) {
            printWriter.println("\nRooted by minimizing tree height.");
            System.out.println("\nRooted by minimizing tree height.");
        } else {
            printWriter.println("\nNo (re) rooting was performed.");
            System.out.println("\nNo (re) rooting was performed.");
        }
        printWriter.println("\nTrees directory  : " + file);
        printWriter.println("Suffix for trees : " + string);
        printWriter.println("Species tree     : " + file2);
        printWriter.println("Output directory : " + file3);
        printWriter.println("Output file      : " + file4);
        printWriter.println("\nTotal number of attempts (tree files read)       : " + n9);
        printWriter.println("Total number of successfully assigned trees      : " + n2);
        printWriter.println("Number of too small trees                        : " + n3);
        printWriter.println("Number of too large trees                        : " + n4);
        printWriter.println("\nSum of duplications                                   : " + l);
        if (bl2) {
            printWriter.println("Sum of mapping costs L                                : " + l3);
        }
        if (bl4) {
            printWriter.println("Sum of tree heights                                   : " + d);
            printWriter.println("Sum of differences in subtree heights                 : " + d2);
        }
        printWriter.println("Sum of external nodes (in successfully assigned trees): " + l2);
        printWriter.close();
        System.out.println("\nTotal number of attempts (tree files read)       : " + n9);
        System.out.println("Total number of successfully assigned trees      : " + n2);
        System.out.println("Number of too small trees                        : " + n3);
        System.out.println("Number of too large trees                        : " + n4);
        System.out.println("\nSum of duplications                                   : " + l);
        if (bl2) {
            System.out.println("Sum of mapping costs L                                : " + l3);
        }
        if (bl4) {
            System.out.println("Sum of tree heights                                   : " + d);
            System.out.println("Sum of differences in subtree heights                 : " + d2);
        }
        System.out.println("Sum of external nodes (in successfully assigned trees): " + l2);
        printWriter2 = new PrintWriter((Writer)new FileWriter(file6), true);
        for (n = 0; n < nArray.length && n <= 50; ++n) {
            printWriter2.println(n + " " + nArray[n]);
        }
        printWriter2.close();
        printWriter3 = new PrintWriter((Writer)new FileWriter(file7), true);
        for (n = 0; n < nArray2.length && n <= 1000; ++n) {
            printWriter3.println(n + " " + nArray2[n]);
        }
        printWriter3.close();
    }

    public static void main(String[] stringArray) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        File file = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        String string = null;
        if (stringArray.length == 5) {
            file = new File(stringArray[0]);
            string = stringArray[1];
            file2 = new File(stringArray[2]);
            file3 = new File(stringArray[3]);
            file4 = new File(stringArray[4]);
        } else if (stringArray.length == 6) {
            if (stringArray[0].startsWith("-")) {
                bl = false;
                bl2 = false;
                bl3 = false;
                bl4 = false;
                if (stringArray[0].toLowerCase().indexOf("w") != -1) {
                    bl4 = true;
                }
                if (stringArray[0].toLowerCase().indexOf("l") != -1) {
                    bl = true;
                }
                if (stringArray[0].toLowerCase().indexOf("d") != -1) {
                    bl2 = true;
                }
                if (stringArray[0].toLowerCase().indexOf("h") != -1) {
                    bl3 = true;
                }
            } else {
                sdi_dir.errorInCommandLine();
            }
            file = new File(stringArray[1]);
            string = stringArray[2];
            file2 = new File(stringArray[3]);
            file3 = new File(stringArray[4]);
            file4 = new File(stringArray[5]);
        } else {
            sdi_dir.errorInCommandLine();
        }
        if (bl && bl2) {
            bl2 = false;
        }
        try {
            sdi_dir.infer(file, file2, file3, file4, string, bl4, bl, bl2, bl3);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, "error: " + exception.getLocalizedMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "OK.");
    }
}

