/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiTau;
import JSci.physics.particles.Lepton;
import JSci.physics.particles.Photon;
import JSci.physics.particles.TauNeutrino;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class Tau
extends Lepton {
    public double restMass() {
        return 1777.03;
    }

    public int charge() {
        return -1;
    }

    public int eLeptonQN() {
        return 0;
    }

    public int muLeptonQN() {
        return 0;
    }

    public int tauLeptonQN() {
        return 1;
    }

    public QuantumParticle anti() {
        return new AntiTau();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof AntiTau;
    }

    public String toString() {
        return new String("Tau");
    }

    public Tau emit(Photon photon) {
        this.momentum = this.momentum.subtract(photon.momentum);
        return this;
    }

    public Tau absorb(Photon photon) {
        this.momentum = this.momentum.add(photon.momentum);
        return this;
    }

    public TauNeutrino emit(WMinus wMinus) {
        TauNeutrino tauNeutrino = new TauNeutrino();
        tauNeutrino.momentum = this.momentum.subtract(wMinus.momentum);
        return tauNeutrino;
    }

    public TauNeutrino absorb(WPlus wPlus) {
        TauNeutrino tauNeutrino = new TauNeutrino();
        tauNeutrino.momentum = this.momentum.add(wPlus.momentum);
        return tauNeutrino;
    }

    public Tau emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public Tau absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

