/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.eval;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedAccess;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtGenericElementReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.util.RtHelper;

public class VisitorPartialEvaluator
implements CtVisitor,
PartialEvaluator {
    boolean flowEnded = false;
    CtCodeElement result;

    Number convert(CtTypeReference<?> type, Number n) {
        if (type.getActualClass() == Integer.TYPE || type.getActualClass() == Integer.class) {
            return n.intValue();
        }
        if (type.getActualClass() == Byte.TYPE || type.getActualClass() == Byte.class) {
            return n.byteValue();
        }
        if (type.getActualClass() == Long.TYPE || type.getActualClass() == Long.class) {
            return n.longValue();
        }
        if (type.getActualClass() == Float.TYPE || type.getActualClass() == Float.class) {
            return Float.valueOf(n.floatValue());
        }
        if (type.getActualClass() == Short.TYPE || type.getActualClass() == Short.class) {
            return n.shortValue();
        }
        return n;
    }

    @Override
    public <R extends CtCodeElement> R evaluate(CtElement parent, R element) {
        if (element == null) {
            return null;
        }
        element.accept(this);
        if (this.result != null) {
            this.result.setParent(parent);
        }
        return (R)this.result;
    }

    void setResult(CtCodeElement element) {
        this.result = element;
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable impl) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        this.setResult(arrayAccess.getFactory().Core().clone(arrayAccess));
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        CtExpression<?> left = this.evaluate(operator, operator.getLeftHandOperand());
        CtExpression<?> right = this.evaluate(operator, operator.getRightHandOperand());
        if (left instanceof CtLiteral && right instanceof CtLiteral) {
            Object leftObject = ((CtLiteral)left).getValue();
            Object rightObject = ((CtLiteral)right).getValue();
            CtLiteral<Object> res = operator.getFactory().Core().createLiteral();
            switch (operator.getKind()) {
                case AND: {
                    res.setValue((Boolean)leftObject != false && (Boolean)rightObject != false);
                    break;
                }
                case OR: {
                    res.setValue((Boolean)leftObject != false || (Boolean)rightObject != false);
                    break;
                }
                case EQ: {
                    if (leftObject == null) {
                        res.setValue(leftObject == rightObject);
                        break;
                    }
                    res.setValue(leftObject.equals(rightObject));
                    break;
                }
                case NE: {
                    if (leftObject == null) {
                        res.setValue(leftObject != rightObject);
                        break;
                    }
                    res.setValue(!leftObject.equals(rightObject));
                    break;
                }
                case GE: {
                    res.setValue(((Number)leftObject).doubleValue() >= ((Number)rightObject).doubleValue());
                    break;
                }
                case LE: {
                    res.setValue(((Number)leftObject).doubleValue() <= ((Number)rightObject).doubleValue());
                    break;
                }
                case GT: {
                    res.setValue(((Number)leftObject).doubleValue() > ((Number)rightObject).doubleValue());
                    break;
                }
                case LT: {
                    res.setValue(((Number)leftObject).doubleValue() < ((Number)rightObject).doubleValue());
                    break;
                }
                case MINUS: {
                    res.setValue(this.convert(operator.getType(), ((Number)leftObject).doubleValue() - ((Number)rightObject).doubleValue()));
                    break;
                }
                case MUL: {
                    res.setValue(this.convert(operator.getType(), ((Number)leftObject).doubleValue() * ((Number)rightObject).doubleValue()));
                    break;
                }
                case DIV: {
                    res.setValue(this.convert(operator.getType(), ((Number)leftObject).doubleValue() / ((Number)rightObject).doubleValue()));
                    break;
                }
                case PLUS: {
                    if (leftObject instanceof String || rightObject instanceof String) {
                        res.setValue("" + leftObject + rightObject);
                        break;
                    }
                    res.setValue(this.convert(operator.getType(), ((Number)leftObject).doubleValue() + ((Number)rightObject).doubleValue()));
                    break;
                }
                case BITAND: {
                    if (leftObject instanceof Boolean) {
                        res.setValue((Boolean)leftObject & (Boolean)rightObject);
                        break;
                    }
                    res.setValue(((Number)leftObject).intValue() & ((Number)rightObject).intValue());
                    break;
                }
                case BITOR: {
                    if (leftObject instanceof Boolean) {
                        res.setValue((Boolean)leftObject | (Boolean)rightObject);
                        break;
                    }
                    res.setValue(((Number)leftObject).intValue() | ((Number)rightObject).intValue());
                    break;
                }
                case BITXOR: {
                    if (leftObject instanceof Boolean) {
                        res.setValue((Boolean)leftObject ^ (Boolean)rightObject);
                        break;
                    }
                    res.setValue(((Number)leftObject).intValue() ^ ((Number)rightObject).intValue());
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported operator " + (Object)((Object)operator.getKind()));
                }
            }
            this.setResult(res);
            return;
        }
        if (operator.getKind() == BinaryOperatorKind.INSTANCEOF) {
            CtTypeReference rightType;
            CtLiteral<Boolean> res = operator.getFactory().Core().createLiteral();
            CtTypeReference<?> leftType = left.getType().box();
            if (leftType.isSubtypeOf(rightType = (CtTypeReference)((CtLiteral)right).getValue())) {
                res.setValue(true);
                this.setResult(res);
            }
            return;
        }
        if (left instanceof CtLiteral || right instanceof CtLiteral) {
            CtExpression<?> expr;
            CtLiteral literal;
            if (left instanceof CtLiteral) {
                literal = (CtLiteral)left;
                expr = right;
            } else {
                literal = (CtLiteral)right;
                expr = left;
            }
            Object o = literal.getValue();
            CtLiteral<Boolean> res = operator.getFactory().Core().createLiteral();
            switch (operator.getKind()) {
                case AND: {
                    if (((Boolean)o).booleanValue()) {
                        this.setResult(expr);
                    } else {
                        res.setValue(false);
                        this.setResult(res);
                    }
                    return;
                }
                case OR: {
                    if (((Boolean)o).booleanValue()) {
                        res.setValue(true);
                        this.setResult(res);
                    } else {
                        this.setResult(expr);
                    }
                    return;
                }
                case BITOR: {
                    if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                        res.setValue(true);
                        this.setResult(res);
                    }
                    return;
                }
            }
        }
        CtBinaryOperator op = operator.getFactory().Core().createBinaryOperator();
        op.setKind(operator.getKind());
        op.setLeftHandOperand(left);
        op.setRightHandOperand(right);
        op.setType(operator.getType());
        this.setResult(op);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        CtBlock b = block.getFactory().Core().createBlock();
        for (CtStatement s : block.getStatements()) {
            CtStatement res = this.evaluate(b, s);
            if (res != null) {
                b.addStatement(res);
            }
            if (!this.flowEnded) continue;
            break;
        }
        if (b.getStatements().size() == 1 && b.getStatements().get(0) instanceof CtBlock) {
            this.setResult(b.getStatements().get(0));
        } else {
            this.setResult(b);
        }
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.setResult(breakStatement.getFactory().Core().clone(breakStatement));
    }

    public <E> void visitCtCase(CtCase<E> caseStatement) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.setResult(catchBlock.getFactory().Core().clone(catchBlock));
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.setResult(continueStatement.getFactory().Core().clone(continueStatement));
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        CtDo w = doLoop.getFactory().Core().clone(doLoop);
        w.setLoopingExpression(this.evaluate(w, doLoop.getLoopingExpression()));
        w.setBody(this.evaluate(w, doLoop.getBody()));
        this.setResult(w);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        throw new RuntimeException("Unknow Element");
    }

    public void visitCtExpression(CtExpression<?> expression) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> f) {
        this.visitCtTargetedAccess(f);
    }

    public <T> void visitCtTargetedAccess(CtTargetedAccess<T> targetedAccess) {
        Class<?> c;
        if (targetedAccess.getVariable().getSimpleName().equals("class") && (c = targetedAccess.getVariable().getDeclaringType().getActualClass()) != null) {
            CtLiteral<Class<?>> l = targetedAccess.getFactory().Core().createLiteral();
            l.setValue(c);
            this.setResult(l);
            return;
        }
        if (targetedAccess.getFactory().Type().createReference(Enum.class).isAssignableFrom(targetedAccess.getVariable().getDeclaringType())) {
            CtLiteral<CtFieldReference<T>> l = targetedAccess.getFactory().Core().createLiteral();
            l.setValue(targetedAccess.getVariable());
            this.setResult(l);
            return;
        }
        CtField<T> f = targetedAccess.getVariable().getDeclaration();
        if (f != null && f.getModifiers().contains((Object)ModifierKind.FINAL)) {
            this.setResult(this.evaluate(f, f.getDefaultExpression()));
            return;
        }
        this.setResult(targetedAccess.getFactory().Core().clone(targetedAccess));
    }

    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        this.setResult(thisAccess.getFactory().Core().clone(thisAccess));
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        CtField<T> f = annotationFieldAccess.getVariable().getDeclaration();
        this.setResult(this.evaluate(f, f.getDefaultExpression()));
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        CtStatement evaluateStatement;
        List<CtStatement> lst = forLoop.getForInit();
        ArrayList<CtStatement> evaluatelst = new ArrayList<CtStatement>();
        for (CtStatement s : lst) {
            evaluateStatement = this.evaluate(forLoop, s);
            if (evaluateStatement == null) continue;
            evaluatelst.add(evaluateStatement);
        }
        forLoop.setForInit(evaluatelst);
        forLoop.setExpression(this.evaluate(forLoop, forLoop.getExpression()));
        lst = forLoop.getForUpdate();
        evaluatelst = new ArrayList();
        for (CtStatement s : lst) {
            evaluateStatement = this.evaluate(forLoop, s);
            if (evaluateStatement == null) continue;
            evaluatelst.add(evaluateStatement);
        }
        forLoop.setForUpdate(evaluatelst);
        this.setResult(forLoop.getFactory().Core().clone(forLoop));
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.setResult(foreach.getFactory().Core().clone(foreach));
    }

    public void visitCtGenericElementReference(CtGenericElementReference reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        CtExpression<Boolean> r = this.evaluate(ifElement, ifElement.getCondition());
        if (r instanceof CtLiteral) {
            CtLiteral l = (CtLiteral)r;
            if (((Boolean)l.getValue()).booleanValue()) {
                this.setResult((CtCodeElement)this.evaluate(null, (CtCodeElement)ifElement.getThenStatement()));
            } else {
                this.setResult((CtCodeElement)this.evaluate(null, (CtCodeElement)ifElement.getElseStatement()));
            }
        } else {
            CtIf ifRes = ifElement.getFactory().Core().createIf();
            ifRes.setCondition(r);
            boolean thenEnded = false;
            boolean elseEnded = false;
            ifRes.setThenStatement((CtStatement)this.evaluate(ifRes, (CtCodeElement)ifElement.getThenStatement()));
            if (this.flowEnded) {
                thenEnded = true;
                this.flowEnded = false;
            }
            ifRes.setElseStatement((CtStatement)this.evaluate(ifRes, (CtCodeElement)ifElement.getElseStatement()));
            if (this.flowEnded) {
                elseEnded = true;
                this.flowEnded = false;
            }
            this.setResult(ifRes);
            if (thenEnded && elseEnded) {
                this.flowEnded = true;
            }
        }
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        CtInvocation i = invocation.getFactory().Core().createInvocation();
        i.setType(invocation.getType());
        i.setExecutable(invocation.getExecutable());
        boolean constant = true;
        i.setTarget((CtExpression)this.evaluate(i, (CtCodeElement)invocation.getTarget()));
        if (i.getTarget() != null && !(i.getTarget() instanceof CtLiteral)) {
            constant = false;
        }
        for (CtExpression<?> e : invocation.getArguments()) {
            CtExpression<?> re = this.evaluate(i, e);
            if (!(re instanceof CtLiteral)) {
                constant = false;
            }
            i.addArgument(re);
        }
        if (i.getExecutable().getSimpleName().equals("<init>")) {
            this.setResult(i);
            return;
        }
        if (constant) {
            CtExecutable executable = invocation.getExecutable().getDeclaration();
            if (executable != null && invocation.getType() != null && invocation.getExecutable().getDeclaringType().isAssignableFrom(invocation.getParent(CtType.class).getReference())) {
                CtBlock b = this.evaluate(invocation.getParent(), executable.getBody());
                this.flowEnded = false;
                CtStatement last = b.getStatements().get(b.getStatements().size() - 1);
                if (last != null && last instanceof CtReturn && ((CtReturn)last).getReturnedExpression() instanceof CtLiteral) {
                    this.setResult(((CtReturn)last).getReturnedExpression());
                    return;
                }
            } else {
                Object r = null;
                try {
                    r = RtHelper.invoke(i);
                    CtLiteral<Object> l = invocation.getFactory().Core().createLiteral();
                    l.setValue(r);
                    this.setResult(l);
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.setResult(i);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.setResult(literal.getFactory().Core().clone(literal));
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        CtLocalVariable r = localVariable.getFactory().Core().clone(localVariable);
        r.setDefaultExpression(this.evaluate(r, localVariable.getDefaultExpression()));
        this.setResult(r);
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        CtCatchVariable r = catchVariable.getFactory().Core().clone(catchVariable);
        r.setDefaultExpression(this.evaluate(r, catchVariable.getDefaultExpression()));
        this.setResult(r);
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.setResult(newArray.getFactory().Core().clone(newArray));
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.setResult(ctConstructorCall.getFactory().Core().clone(ctConstructorCall));
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.setResult(newClass.getFactory().Core().clone(newClass));
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.setResult(lambda.getFactory().Core().clone(lambda));
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        this.setResult(expression.getFactory().Core().clone(expression));
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.setResult(assignment.getFactory().Core().clone(assignment));
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList statements) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        throw new RuntimeException("Unknow Element");
    }

    public void visitCtReference(CtReference reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        CtReturn<R> r = returnStatement.getFactory().Core().createReturn();
        r.setReturnedExpression(this.evaluate(r, returnStatement.getReturnedExpression()));
        this.setResult(r);
        this.flowEnded = true;
    }

    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        this.setResult(switchStatement.getFactory().Core().clone(switchStatement));
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        CtSynchronized s = synchro.getFactory().Core().clone(synchro);
        s.setBlock(this.evaluate(s, synchro.getBlock()));
        this.setResult(s);
    }

    public <T, E extends CtExpression<?>> void visitCtTargetedExpression(CtTargetedExpression<T, E> targetedExpression) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        CtThrow r = throwStatement.getFactory().Core().createThrow();
        r.setThrownExpression(this.evaluate(r, throwStatement.getThrownExpression()));
        this.setResult(r);
        this.flowEnded = true;
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.setResult(tryBlock.getFactory().Core().clone(tryBlock));
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.visitCtTry(tryWithResource);
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        throw new RuntimeException("Unknown Element");
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        CtExpression<T> operand = this.evaluate(operator, operator.getOperand());
        if (operand instanceof CtLiteral) {
            Object object = ((CtLiteral)operand).getValue();
            CtLiteral<Boolean> res = operator.getFactory().Core().createLiteral();
            switch (operator.getKind()) {
                case NOT: {
                    res.setValue((Boolean)object == false);
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported operator " + (Object)((Object)operator.getKind()));
                }
            }
            this.setResult(res);
            return;
        }
        this.setResult(operator.getFactory().Core().clone(operator));
    }

    @Override
    public <T> void visitCtVariableAccess(CtVariableAccess<T> variableAccess) {
        CtVariable<T> v = variableAccess.getVariable().getDeclaration();
        if (v != null && v.hasModifier(ModifierKind.FINAL) && v.getDefaultExpression() != null) {
            this.setResult(this.evaluate(v, v.getDefaultExpression()));
        } else {
            this.setResult(variableAccess.getFactory().Core().clone(variableAccess));
        }
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> variableAssignment) {
        CtAssignment<T, A> a = variableAssignment.getFactory().Core().clone(variableAssignment);
        a.setAssignment(this.evaluate(a, a.getAssignment()));
        this.setResult(a);
    }

    public <T> void visitCtVariableReference(CtVariableReference<T> reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        CtWhile w = whileLoop.getFactory().Core().clone(whileLoop);
        w.setLoopingExpression(this.evaluate(w, whileLoop.getLoopingExpression()));
        if (whileLoop.getLoopingExpression() instanceof CtLiteral && !((Boolean)((CtLiteral)whileLoop.getLoopingExpression()).getValue()).booleanValue()) {
            this.setResult(null);
            return;
        }
        w.setBody(this.evaluate(w, whileLoop.getBody()));
        this.setResult(w);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        CtExpression<Boolean> r = this.evaluate(conditional, conditional.getCondition());
        if (r instanceof CtLiteral) {
            CtLiteral l = (CtLiteral)r;
            if (((Boolean)l.getValue()).booleanValue()) {
                this.setResult(this.evaluate(null, conditional.getThenExpression()));
            } else {
                this.setResult(this.evaluate(null, conditional.getElseExpression()));
            }
        } else {
            CtConditional<T> ifRes = conditional.getFactory().Core().createConditional();
            ifRes.setCondition(r);
            ifRes.setThenExpression(this.evaluate(ifRes, conditional.getThenExpression()));
            ifRes.setElseExpression(this.evaluate(ifRes, conditional.getElseExpression()));
            this.setResult(ifRes);
        }
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
        throw new RuntimeException("Unknow Element");
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.visitCtTargetedAccess(f);
    }
}

