/*
 * Decompiled with CFR 0.152.
 */
package conifer.trees;

import conifer.particle.PhyloParticle;
import fig.basic.UnorderedPair;
import fig.prob.Distrib;
import goblin.Taxon;
import monaco.Density;
import nuts.io.IO;
import pty.UnrootedTree;
import pty.smc.PartialCoalescentState;

public class StandardNonClockPriorDensity
implements Density<PhyloParticle> {
    private static final long serialVersionUID = 1L;
    private Distrib<Double> branchDistribution;

    public StandardNonClockPriorDensity(Distrib<Double> branchDistribution) {
        this.branchDistribution = branchDistribution;
    }

    @Override
    public double logDensity(PhyloParticle point) {
        double sum = 0.0;
        if (point instanceof PartialCoalescentState) {
            IO.warnOnce("Clean this hack: StandardNonClockPriorDensity");
            return 0.0;
        }
        UnrootedTree ut = point.getPhylogeny().getUnrooted();
        for (UnorderedPair<Taxon, Taxon> edge : ut.edges()) {
            sum += this.branchDistribution.logProbObject(ut.branchLength(edge));
        }
        return sum;
    }
}

