/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.ex.TreeGenerators;
import ev.poi.processors.TreeDistancesProcessor;
import fig.basic.Option;
import goblin.Taxon;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import ma.MSAParser;
import ma.SequenceType;
import nuts.io.IO;
import nuts.maxent.SloppyMath;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.mcmc.PhyloSampler;
import pty.mcmc.ProposalDistribution;
import pty.mcmc.UnrootedTreeState;

public class PhyloSamplerMain
implements Runnable {
    @Option
    public File alignmentInputFile = null;
    @Option
    public SequenceType st = SequenceType.RNA;
    @Option
    public Random initTreeRandom = new Random(2L);
    private PhyloSampler sampler = null;
    public UnrootedTree consensus = null;
    public TreeDistancesProcessor tdp = null;
    private double[] temperatureSchedule;
    private int nSamplesEachChain = 10000;
    private double logZ = 0.0;
    @Option
    public boolean computeLogZUsingSteppingStone = false;

    @Override
    public void run() {
        this.sampler = new PhyloSampler();
        this.sampler.setOutputText(true);
        List<Taxon> leaves = MSAParser.parseMSA(this.alignmentInputFile).taxa();
        RootedTree initTree = TreeGenerators.sampleCoalescent(this.initTreeRandom, leaves, false);
        UnrootedTreeState ncts = UnrootedTreeState.fromAlignment(UnrootedTree.fromRooted(initTree), this.alignmentInputFile, this.st);
        this.sampler.init(ncts);
        this.tdp = new TreeDistancesProcessor();
        PhyloSampler.PhyloProcessorAdaptor tdpa = new PhyloSampler.PhyloProcessorAdaptor(this.tdp);
        this.sampler.setProcessors(Arrays.asList(tdpa));
        this.sampler.sampleManyTimes();
        this.consensus = this.tdp.getConsensus();
        int nSampleUsed = (int)((double)this.nSamplesEachChain * 0.8);
        int nBurnin = this.nSamplesEachChain - nSampleUsed;
        if (this.computeLogZUsingSteppingStone) {
            for (int i = 1; i < this.temperatureSchedule.length; ++i) {
                this.sampler = this.sampler.createHeatedVersion(this.temperatureSchedule[i]);
                this.sampler.init(this.sampler.getCurrentState());
                double[] logweights = new double[nSampleUsed];
                double tempDiff = this.temperatureSchedule[i - 1] - this.temperatureSchedule[i];
                for (int j = 0; j < this.nSamplesEachChain; ++j) {
                    this.sampler.sample();
                    if (j < nBurnin) continue;
                    logweights[j - nBurnin] = tempDiff * this.sampler.logLikelihood();
                }
                this.setLogZ(this.getLogZ() + (SloppyMath.logAdd(logweights) - Math.log(nSampleUsed)));
            }
        }
    }

    public static void main(String[] args) {
        IO.run(args, new PhyloSamplerMain(), "prop", ProposalDistribution.Util._defaultProposalDistributionOptions, "phylo", PhyloSampler._defaultPhyloSamplerOptions, "prior", PhyloSampler._defaultPriorOptions);
    }

    public double[] getTemperatureSchedule() {
        return this.temperatureSchedule;
    }

    public void setTemperatureSchedule(double[] temperatureSchedule) {
        this.temperatureSchedule = temperatureSchedule;
    }

    public int getnSamplesEachChain() {
        return this.nSamplesEachChain;
    }

    public void setnSamplesEachChain(int nSamplesEachChain) {
        this.nSamplesEachChain = nSamplesEachChain;
    }

    public double getLogZ() {
        return this.logZ;
    }

    public void setLogZ(double logZ) {
        this.logZ = logZ;
    }
}

