/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import fig.basic.IOUtils;
import fig.basic.StrUtils;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import ma.MSAParser;
import ma.MSAPoset;
import ma.SequenceType;
import nuts.io.IO;

public class NexusWriter {
    public static void writeNexus(MSAPoset align, File destination, SequenceType sequenceType) {
        NexusWriter.writeNexus(align, destination, sequenceType, null);
    }

    public static void writeNexus(MSAPoset align, File destination, SequenceType sequenceType, String startingTreePath) {
        PrintWriter out = IOUtils.openOutEasy(destination);
        out.append("begin data;\n");
        out.append("dimensions ntax=" + align.nTaxa() + " nchar=" + align.columns().size() + ";\n");
        out.append("format datatype=" + NexusWriter.datatype(sequenceType) + " interleave=no missing=? gap=-;\n");
        out.append("matrix\n");
        List<MSAPoset.Column> linearized = align.linearizedColumns();
        for (Taxon t : align.taxa()) {
            out.append("" + t + "\n");
            for (MSAPoset.Column c : linearized) {
                if (c.getPoints().containsKey(t)) {
                    out.append("" + align.charAt(c, t));
                    continue;
                }
                out.append("-");
            }
            out.append("\n");
        }
        out.append(";\nend;\n");
        if (!StrUtils.isEmpty(startingTreePath)) {
            out.println("begin trees;");
            out.println("\ttree mystarttree = " + IO.f2s(startingTreePath).replaceAll("internal[0-9]*", "").replaceAll("[;]$", "") + ";");
            out.println("end;");
            out.println("begin mrbayes;");
            out.println("\tstartvals");
            out.println("\t\ttau = mystarttree");
            out.println("\t\tV = mystarttree");
            out.println("\t;");
            out.println("end;");
        }
        out.close();
    }

    private static String datatype(SequenceType sequenceType) {
        if (sequenceType == SequenceType.BINARY) {
            return "standard";
        }
        if (sequenceType == SequenceType.DNA) {
            return "dna";
        }
        if (sequenceType == SequenceType.RNA) {
            return "rna";
        }
        throw new RuntimeException("Need to add clause to nexus sequence type format...");
    }

    public static void main(String[] args) {
        MSAPoset msa = MSAParser.parseMSA(new File("/Users/bouchard/w/evolvere/e/889.exec/output/sim-0.msf"));
        File out = new File("scratch/teest.nex");
        NexusWriter.writeNexus(msa, out, SequenceType.RNA);
    }
}

