/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.Fmt;
import fig.basic.IOUtils;
import fig.basic.ListUtils;
import fig.basic.StrUtils;
import fig.basic.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

public class SysInfoUtils {
    private static int numCPUs = -1;
    private static int cpuSpeed = -1;

    public static String getCurrentDateStr() {
        return new Date().toString();
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "(unknown)";
        }
    }

    public static String getShortHostName() {
        String name = SysInfoUtils.getHostName();
        int i = name.indexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static String getcwd() {
        return System.getProperty("user.dir");
    }

    public static int getNumCPUs() {
        if (numCPUs != -1) {
            return numCPUs;
        }
        try {
            int n = 0;
            for (String line : IOUtils.readLines("/proc/cpuinfo")) {
                if (!line.startsWith("processor")) continue;
                ++n;
            }
            numCPUs = n;
            return numCPUs;
        }
        catch (IOException e) {
            try {
                numCPUs = Integer.parseInt(StrUtils.split(Utils.systemGetStringOutput("sysctl hw.ncpu").trim(), " ")[1]);
                return numCPUs;
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    public static int getNumUsedCPUs() {
        try {
            int n = 0;
            for (String line : StrUtils.split(Utils.systemGetStringOutput("ps ax -o pcpu"), "\n")) {
                double percentCPU = Utils.parseDoubleEasy(line);
                if (percentCPU > 50.0) {
                    ++n;
                }
                if (percentCPU > 150.0) {
                    ++n;
                }
                if (percentCPU > 250.0) {
                    ++n;
                }
                if (!(percentCPU > 350.0)) continue;
                ++n;
            }
            return n;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int getNumFreeCPUs() {
        return SysInfoUtils.getNumCPUs() - SysInfoUtils.getNumUsedCPUs();
    }

    public static int getCPUSpeed() {
        if (cpuSpeed != -1) {
            return cpuSpeed;
        }
        try {
            double sum = 0.0;
            int n = 0;
            for (String line : IOUtils.readLines("/proc/cpuinfo")) {
                if (!line.startsWith("cpu MHz")) continue;
                sum += Double.parseDouble(ListUtils.getLast(StrUtils.split(line)));
                ++n;
            }
            cpuSpeed = (int)(sum / (double)n + 0.5);
            return cpuSpeed;
        }
        catch (IOException e) {
            try {
                cpuSpeed = Integer.parseInt(StrUtils.split(Utils.systemGetStringOutput("sysctl hw.cpufrequency").trim(), " ")[1]) / 1000000;
                return cpuSpeed;
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    public static String getCPUSpeedStr() {
        return SysInfoUtils.getCPUSpeed() + " MHz";
    }

    public static String getMaxMemoryStr() {
        long mem = Runtime.getRuntime().maxMemory();
        return Fmt.bytesToString(mem);
    }

    public static String getUsedMemoryStr() {
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        return Fmt.bytesToString(totalMem - freeMem);
    }

    public static long getFreeMemory() {
        try {
            boolean n = false;
            long memfree = 0L;
            long buffers = 0L;
            long cached = 0L;
            for (String line : IOUtils.readLines("/proc/meminfo")) {
                if (line.startsWith("MemFree:")) {
                    memfree = Long.parseLong(line.split("\\s+")[1]);
                }
                if (line.startsWith("Buffers:")) {
                    buffers = Long.parseLong(line.split("\\s+")[1]);
                }
                if (!line.startsWith("Cached:")) continue;
                cached = Long.parseLong(line.split("\\s+")[1]);
            }
            return (memfree + buffers + cached) * 1024L;
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

