/*
 * Decompiled with CFR 0.152.
 */
package infer;

import nuts.math.GMFct;
import nuts.math.Graph;
import nuts.math.Graphs;
import nuts.math.TreeSumProd;
import nuts.util.Tree;

public final class Exact2DIsing {
    private final int L;
    private final double[][] pot;
    private final Pot2DIsing isingPot = new Pot2DIsing();
    private final TreeSumProd<Integer> tsp;

    private int[] convert(int i) {
        return Graphs.Grid.int2coord(i, this.L, this.vStateSize());
    }

    public Exact2DIsing(int L, double[][] pot) {
        this.L = L;
        this.pot = pot;
        this.tsp = this.compute();
    }

    public static void main(String[] args) {
        double[][] pot = new double[][]{{1.0, 1.0}, {1.0, 1.0}};
        Exact2DIsing ei = new Exact2DIsing(2, pot);
    }

    public double logZ() {
        return this.tsp.logZ();
    }

    public int vStateSize() {
        return this.pot.length;
    }

    public Graph<Integer> graph() {
        return this.tsp.moments().graph();
    }

    private TreeSumProd<Integer> compute() {
        TreeSumProd<Integer> tsp = new TreeSumProd<Integer>(this.isingPot);
        return tsp;
    }

    private static Tree<Integer> chainTree(int L) {
        Tree<Integer> result;
        Tree<Integer> current = result = new Tree<Integer>(0);
        for (int l = 0; l < L - 1; ++l) {
            Tree<Integer> newTree = new Tree<Integer>(current.getLabel() + 1);
            current.getChildren().add(newTree);
            current = newTree;
        }
        return result;
    }

    private final class Pot2DIsing
    implements GMFct<Integer> {
        private Pot2DIsing() {
        }

        private double interactions(int[] convert, int[] convert2) {
            double result = 1.0;
            for (int i = 0; i < convert.length; ++i) {
                result *= Exact2DIsing.this.pot[convert[i]][convert2[i]];
            }
            return result;
        }

        private double singleton(int[] convert) {
            double result = 1.0;
            for (int i = 0; i < convert.length - 1; ++i) {
                result *= Exact2DIsing.this.pot[convert[i]][convert[i + 1]];
            }
            return result;
        }

        @Override
        public int nStates(Integer node) {
            return (int)Math.pow(Exact2DIsing.this.vStateSize(), Exact2DIsing.this.L);
        }

        @Override
        public double get(Integer n1, Integer n2, int s1, int s2) {
            return this.interactions(Exact2DIsing.this.convert(s1), Exact2DIsing.this.convert(s2));
        }

        @Override
        public double get(Integer n, int s) {
            return this.singleton(Exact2DIsing.this.convert(s));
        }

        @Override
        public Graph<Integer> graph() {
            return Graphs.chainGraph(Exact2DIsing.this.L);
        }
    }
}

