/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel.features;

import fig.basic.Pair;
import goblin.Taxon;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.util.Counter;
import pepper.Effect;
import pepper.Environment;
import pepper.editmodel.features.EditTypeFeaturesExtractor;
import pepper.editmodel.features.MultiGranEditFeaturesExtractor;

public class GlobalFeatureExtractor
implements FeatureExtractor<LabeledInstance<Pair<Taxon, Environment>, Effect>, String> {
    private MultiGranEditFeaturesExtractor mgefe = new MultiGranEditFeaturesExtractor();
    private EditTypeFeaturesExtractor etfe = new EditTypeFeaturesExtractor();

    @Override
    public Counter<String> extractFeatures(LabeledInstance<Pair<Taxon, Environment>, Effect> instance) {
        Taxon lang = instance.getInput().getFirst();
        Environment env = instance.getInput().getSecond();
        Counter<String> counter = new Counter<String>();
        counter.incrementAll(this.mgefe.extractFeatures(new LabeledInstance<Environment, Effect>(instance.getLabel(), env)));
        counter.incrementAll(this.etfe.extractFeatures(new LabeledInstance<Environment, Effect>(instance.getLabel(), env)));
        Counter<String> transformed = new Counter<String>();
        for (String string : counter.keySet()) {
            transformed.setCount("" + lang + ":" + string, counter.getCount(string));
        }
        return transformed;
    }

    @Override
    public double regularizationFactor(String feature) {
        if (feature.equals("SELF-SUB") || feature.equals("FISSION") || feature.equals("SUBSTITUTION") || feature.equals("DELETION")) {
            return 1.1;
        }
        return MultiGranEditFeaturesExtractor.regFactor(feature);
    }
}

