/*
 * Decompiled with CFR 0.152.
 */
package practice;

import fig.basic.LogInfo;
import fig.basic.Pair;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import practice.ForestState;
import practice.Language;
import pty.smc.ParticleKernel;

public class CognateTreeKernel
implements ParticleKernel<ForestState> {
    private List<Language> languages;
    private ForestState.RateMatrix Q;
    private double p;

    public CognateTreeKernel(List<Language> languages, ForestState.RateMatrix Q, double p) {
        this.languages = languages;
        this.Q = Q;
        this.p = p;
    }

    @Override
    public Pair<ForestState, Double> next(Random rand, ForestState current) {
        int branch = 1;
        while (rand.nextDouble() < current.param) {
            ++branch;
        }
        LogInfo.logs("numTrees=" + current.numTrees());
        List<Integer> sampledIndices = Sampling.sampleWithoutReplacement(rand, current.numTrees(), 2);
        int i0 = sampledIndices.get(0);
        int i1 = sampledIndices.get(1);
        LogInfo.logs("tree0=" + i0 + ", tree1=" + i1);
        ForestState next = new ForestState(current);
        double weight = next.merge(i0, i1, branch);
        return new Pair<ForestState, Double>(next, weight);
    }

    @Override
    public int nIterationsLeft(ForestState partialState) {
        return partialState.nIterationLeft();
    }

    @Override
    public ForestState getInitial() {
        ForestState initialState = new ForestState(this.p, this.Q, this.languages);
        return initialState;
    }
}

