/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import briefj.BriefIO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MergeWebworkClickers {
    public static String[] gradeFiles = new String[]{"webwork-final-raw.csv", "clicker-final-raw.csv"};
    public static String mappingFile = "clicker-webwork-map.txt";
    public static List<Map<String, Map<String, Double>>> grades = Lists.newArrayList();
    public static List<Set<String>> allIndices = Lists.newArrayList();
    public static List<List<List<String>>> indices = Lists.newArrayList();

    public static void main(String[] args) {
        for (int i = 0; i < gradeFiles.length; ++i) {
            allIndices.add(new LinkedHashSet());
            indices.add(new ArrayList());
        }
        for (String[] line : BriefIO.readLines((String)mappingFile).splitCSV()) {
            int fileIndex = 0;
            for (String indicesString : line) {
                List<String> currentIndices = Arrays.asList(indicesString.split("\\s+"));
                allIndices.get(fileIndex).addAll(currentIndices);
                indices.get(fileIndex).add(currentIndices);
                ++fileIndex;
            }
        }
        int fileIndex = 0;
        for (String gradeFile : gradeFiles) {
            LinkedHashMap gradeMap = Maps.newLinkedHashMap();
            grades.add(gradeMap);
            for (Map line : BriefIO.readLines((String)gradeFile).indexCSV()) {
                String studentId = ((String)line.get("Username")).replaceAll("\\s+", "");
                if (StringUtils.isEmpty((CharSequence)studentId)) continue;
                HashMap studentGrades = Maps.newHashMap();
                gradeMap.put(studentId, studentGrades);
                for (String index : line.keySet()) {
                    if (!allIndices.get(fileIndex).contains(index.replaceAll("\\s+", "").replaceAll("\"", ""))) continue;
                    String entry = (String)line.get(index);
                    double parsed = StringUtils.isEmpty((CharSequence)entry) ? 0.0 : Double.parseDouble(entry);
                    studentGrades.put(index.replaceAll("\\s+", "").replaceAll("\"", ""), parsed);
                }
            }
            ++fileIndex;
        }
        ArrayList maxes = Lists.newArrayList();
        for (int i = 0; i < grades.size(); ++i) {
            LinkedHashMap<String, Double> max = new LinkedHashMap<String, Double>();
            maxes.add(max);
            for (String studentId : grades.get(i).keySet()) {
                for (String index : grades.get(i).get(studentId).keySet()) {
                    double current = grades.get(i).get(studentId).get(index);
                    double d = max.containsKey(index) ? (Double)max.get(index) : -1.0;
                    double old = d;
                    if (!(current > old)) continue;
                    max.put(index, current);
                }
            }
        }
        LinkedHashSet allIds = Sets.newLinkedHashSet();
        allIds.addAll(grades.get(0).keySet());
        allIds.addAll(grades.get(1).keySet());
        System.out.println("sid,grade");
        for (String studentId : allIds) {
            double[] groupGrade = new double[6];
            for (int i = 0; i < 6; ++i) {
                double max = 0.0;
                for (fileIndex = 0; fileIndex < 2; ++fileIndex) {
                    double current = 0.0;
                    for (String index : indices.get(fileIndex).get(i)) {
                        try {
                            current += grades.get(fileIndex).get(studentId).get(index) / (Double)((Map)maxes.get(fileIndex)).get(index);
                        }
                        catch (NullPointerException npe) {}
                    }
                    if (!((current /= (double)indices.get(fileIndex).get(i).size()) > max)) continue;
                    max = current;
                }
                groupGrade[i] = max;
            }
            System.out.println(studentId + "," + MergeWebworkClickers.averageDropWorst(groupGrade));
        }
    }

    private static double averageDropWorst(double[] groupGrade) {
        if (groupGrade.length < 2) {
            throw new RuntimeException();
        }
        double min = Double.POSITIVE_INFINITY;
        int argmin = -1;
        for (int i = 0; i < groupGrade.length; ++i) {
            double cur = groupGrade[i];
            if (!(cur < min)) continue;
            min = cur;
            argmin = i;
        }
        double sum = 0.0;
        for (int i = 0; i < groupGrade.length; ++i) {
            if (i == argmin) continue;
            sum += groupGrade[i];
        }
        return sum / ((double)groupGrade.length - 1.0);
    }
}

