/*
 * Decompiled with CFR 0.152.
 */
package slice.processor;

import fig.basic.CharEncUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import slice.SampleProcessor;
import slice.stickrep.DPMSample;
import slice.stickrep.Location;

public class PrintSampleProcessor<L extends Location<D>, D>
implements SampleProcessor<L, D> {
    private DPMSample<L, D> sample;
    private int interval;
    private int nSamples = 0;
    private List<Double> auxRef = null;

    public PrintSampleProcessor(int interval) {
        this.interval = interval;
    }

    private void newSample() {
        if (this.nSamples % this.interval == 0) {
            try {
                this.printCurrentSample(CharEncUtils.getWriter(System.out));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ++this.nSamples;
    }

    public void printCurrentSample(PrintWriter out) {
        out.append(this.sample.toString());
        out.flush();
    }

    @Override
    public void processAuxiliarySliceSample(int dataIndex, double newValue) {
        this.newSample();
    }

    @Override
    public void processIndicatorSample(int dataIndex, int newIndicatorValue) {
        this.newSample();
    }

    @Override
    public void processLocationSample(int clusterIndex, L newLocation) {
        this.newSample();
    }

    @Override
    public void processStickSample(int clusterIndex, double newWLength) {
        this.newSample();
    }

    @Override
    public void setAuxiliarySlice(List<Double> auxRef) {
        this.auxRef = auxRef;
    }

    @Override
    public void setSample(DPMSample<L, D> sampleRef) {
        this.sample = sampleRef;
    }
}

