/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.csparsej.tdcomplex;

public class DZcs_complex {
    public static final double[] cs_czero() {
        return new double[]{0.0, 0.0};
    }

    public static final double[] cs_cone() {
        return new double[]{1.0, 0.0};
    }

    public static final double cs_creal(double[] x) {
        return x[0];
    }

    public static final double cs_cimag(double[] x) {
        return x[1];
    }

    public static final double[] cs_cget(double[] x, int idx) {
        return new double[]{x[idx], x[idx + 1]};
    }

    public static final void cs_cset(double[] x, int idx, double[] val) {
        x[idx] = val[0];
        x[idx + 1] = val[1];
    }

    public static final boolean cs_cequal(double[] x, double[] y) {
        return DZcs_complex.cs_cequal(x, y, 1.0E-14);
    }

    public static final boolean cs_cequal(double[] x, double[] y, double tol) {
        return DZcs_complex.cs_cabs(x[0] - y[0], x[1] - y[1]) <= Math.abs(tol);
    }

    public static final double cs_cabs(double[] x) {
        double absX = Math.abs(x[0]);
        double absY = Math.abs(x[1]);
        if (absX == 0.0 && absY == 0.0) {
            return 0.0;
        }
        if (absX >= absY) {
            double d = x[1] / x[0];
            return absX * Math.sqrt(1.0 + d * d);
        }
        double d = x[0] / x[1];
        return absY * Math.sqrt(1.0 + d * d);
    }

    public static final double cs_cabs(double re, double im) {
        double absX = Math.abs(re);
        double absY = Math.abs(im);
        if (absX == 0.0 && absY == 0.0) {
            return 0.0;
        }
        if (absX >= absY) {
            double d = im / re;
            return absX * Math.sqrt(1.0 + d * d);
        }
        double d = re / im;
        return absY * Math.sqrt(1.0 + d * d);
    }

    public static final double[] cs_conj(double[] x) {
        return new double[]{x[0], -x[1]};
    }

    public static final double[] cs_cdiv(double[] x, double re, double im) {
        double[] z = new double[2];
        if (Math.abs(re) >= Math.abs(im)) {
            double scalar = 1.0 / (re + im * (im / re));
            z[0] = scalar * (x[0] + x[1] * (im / re));
            z[1] = scalar * (x[1] - x[0] * (im / re));
        } else {
            double scalar = 1.0 / (re * (re / im) + im);
            z[0] = scalar * (x[0] * (re / im) + x[1]);
            z[1] = scalar * (x[1] * (re / im) - x[0]);
        }
        return z;
    }

    public static final double[] cs_cdiv(double[] x, double[] y) {
        return DZcs_complex.cs_cdiv(x, y[0], y[1]);
    }

    public static final double[] cs_cplus(double[] x, double[] y) {
        return new double[]{x[0] + y[0], x[1] + y[1]};
    }

    public static final double[] cs_cminus(double[] x, double[] y) {
        return new double[]{x[0] - y[0], x[1] - y[1]};
    }

    public static final double[] cs_cmult(double[] x, double y) {
        return new double[]{x[0] * y, x[1] * y};
    }

    public static final double[] cs_cmult(double[] x, double[] y) {
        return new double[]{x[0] * y[0] - x[1] * y[1], x[1] * y[0] + x[0] * y[1]};
    }

    public static final double[] cs_cneg(double[] x) {
        double[] neg_one = new double[]{-1.0, 0.0};
        return DZcs_complex.cs_cmult(neg_one, x);
    }

    public static final double[] cs_csqrt(double[] x) {
        double[] z = new double[2];
        double absx = DZcs_complex.cs_cabs(x);
        if (absx > 0.0) {
            if (x[0] > 0.0) {
                double tmp;
                z[0] = tmp = Math.sqrt(0.5 * (absx + x[0]));
                z[1] = 0.5 * (x[1] / tmp);
            } else {
                double tmp = Math.sqrt(0.5 * (absx - x[0]));
                if (x[1] < 0.0) {
                    tmp = -tmp;
                }
                z[0] = 0.5 * (x[1] / tmp);
                z[1] = tmp;
            }
        } else {
            z[0] = 0.0;
            z[1] = 0.0;
        }
        return z;
    }

    public static final double[] cs_csquare(double[] x) {
        return DZcs_complex.cs_cmult(x, x);
    }
}

