/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tchar;

import cern.colt.PersistentObject;
import cern.colt.buffer.tchar.CharBuffer2DConsumer;
import cern.colt.list.tchar.CharArrayList;

public class CharBuffer2D
extends PersistentObject
implements CharBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected CharBuffer2DConsumer target;
    protected char[] xElements;
    protected char[] yElements;
    protected CharArrayList xList;
    protected CharArrayList yList;
    protected int capacity;
    protected int size;

    public CharBuffer2D(CharBuffer2DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new char[capacity];
        this.yElements = new char[capacity];
        this.xList = new CharArrayList(this.xElements);
        this.yList = new CharArrayList(this.yElements);
        this.size = 0;
    }

    public void add(char x, char y) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size++] = y;
    }

    public void addAllOf(CharArrayList x, CharArrayList y) {
        int listSize = x.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(x, y);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

