/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.Timer;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseDComplexMatrix1D {
    private static final Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseDComplexMatrix1D.txt";
    private static double[] noViewTimes;
    private static double[] viewTimes;
    private static double[] a;
    private static double[] b;

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tdcomplex.impl.BenchmarkDenseDComplexMatrix1D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int i;
        BenchmarkMatrixKernel.readSettings1D();
        Random rand = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        a = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D];
        for (i = 0; i < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D; ++i) {
            BenchmarkDenseDComplexMatrix1D.a[i] = rand.nextDouble();
        }
        b = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D];
        for (i = 0; i < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D; ++i) {
            BenchmarkDenseDComplexMatrix1D.b[i] = rand.nextDouble();
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, new int[]{BenchmarkMatrixKernel.MATRIX_SIZE_1D});
        BenchmarkMatrixKernel.displayProperties(new int[]{BenchmarkMatrixKernel.MATRIX_SIZE_1D});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a = null;
        b = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateDComplexDComplexDComplexFunctionDComplexDComplexFunction() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] aSum = ((DComplexMatrix1D)A).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = ((DComplexMatrix1D)A).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] aSum = Av.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = Av.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "aggregate(DComplexDComplexDComplexFunction, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDComplexMatrix1DDComplexDComplexDComplexFunctionDComplexDComplexDComplexFunction() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        DenseDComplexMatrix1D B = new DenseDComplexMatrix1D(b);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] aSum = ((DComplexMatrix1D)A).aggregate(B, DComplexFunctions.plus, DComplexFunctions.mult);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = ((DComplexMatrix1D)A).aggregate(B, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        DComplexMatrix1D Bv = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(b);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] aSum = Av.aggregate(Bv, DComplexFunctions.plus, DComplexFunctions.mult);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = Av.aggregate(Bv, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "aggregate(DComplexMatrix1D, DComplexDComplexDComplexFunction, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleDouble() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        double value = Math.random();
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix1D)A).assign(value, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix1D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix1D)A).assign(value, value);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(value, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(value, value);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(double, double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArray() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix1D)A).assign(a);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix1D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix1D)A).assign(a);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(a);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(a);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexDComplexFunction() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix1D)A).assign(DComplexFunctions.acos);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix1D)A).assign(a);
                t.reset().start();
                ((DComplexMatrix1D)A).assign(DComplexFunctions.acos);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(DComplexFunctions.acos);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a);
                t.reset().start();
                Av.assign(DComplexFunctions.acos);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix1D() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        DenseDComplexMatrix1D B = new DenseDComplexMatrix1D(a);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix1D)A).assign(B);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix1D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix1D)A).assign(B);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        DComplexMatrix1D Av = A.viewFlip();
        B = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D Bv = B.viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(Bv);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(Bv);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix1DDComplexDComplexDComplexFunction() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        DenseDComplexMatrix1D B = new DenseDComplexMatrix1D(b);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix1D)A).assign(B, DComplexFunctions.div);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix1D)A).assign(a);
                t.reset().start();
                ((DComplexMatrix1D)A).assign(B, DComplexFunctions.div);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        DComplexMatrix1D Bv = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(b);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(Bv, DComplexFunctions.div);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a);
                t.reset().start();
                Av.assign(Bv, DComplexFunctions.div);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexMatrix1D, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDoubleArray() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        double[] value = new double[]{-1.0, -2.0};
        DComplexProcedure procedure = new DComplexProcedure(){

            public boolean apply(double[] element) {
                return DComplex.abs(element) > 0.1;
            }
        };
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix1D)A).assign(procedure, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix1D)A).assign(a);
                t.reset().start();
                ((DComplexMatrix1D)A).assign(procedure, value);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(procedure, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a);
                t.reset().start();
                Av.assign(procedure, value);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexProcedure, double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDComplexDComplexFunction() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        DComplexProcedure procedure = new DComplexProcedure(){

            public boolean apply(double[] element) {
                return DComplex.abs(element) > 0.1;
            }
        };
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix1D)A).assign(procedure, DComplexFunctions.tan);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix1D)A).assign(a);
                t.reset().start();
                ((DComplexMatrix1D)A).assign(procedure, DComplexFunctions.tan);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(procedure, DComplexFunctions.tan);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a);
                t.reset().start();
                Av.assign(procedure, DComplexFunctions.tan);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexProcedure, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            int card = A.cardinality();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                card = A.cardinality();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D Av = A.viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            int card = Av.cardinality();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                card = Av.cardinality();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetImaginaryPart() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int slices = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int rows = 16;
        int columns = 4;
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DoubleMatrix1D B = ((DComplexMatrix1D)A).getImaginaryPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix1D)A).getImaginaryPart();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D Av = A.viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DoubleMatrix1D B = Av.getImaginaryPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = Av.getImaginaryPart();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "getImaginaryPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetRealPart() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int slices = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int rows = 16;
        int columns = 4;
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DoubleMatrix1D B = ((DComplexMatrix1D)A).getRealPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix1D)A).getRealPart();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D Av = A.viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DoubleMatrix1D B = Av.getRealPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = Av.getRealPart();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "getRealPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[i]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            A.fft();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a);
                t.reset().start();
                A.fft();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[i2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseDComplexMatrix1D)Av).fft();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a);
                t.reset().start();
                ((DenseDComplexMatrix1D)Av).fft();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "fft()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[i]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            A.ifft(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a);
                t.reset().start();
                A.ifft(true);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[i2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseDComplexMatrix1D)Av).ifft(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a);
                t.reset().start();
                ((DenseDComplexMatrix1D)Av).ifft(true);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "ifft(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testReshapeIntInt() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int rows = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int columns = 64;
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DComplexMatrix2D B = ((DComplexMatrix1D)A).reshape(rows, columns);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix1D)A).reshape(rows, columns);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D Av = A.viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DComplexMatrix2D B = Av.reshape(rows, columns);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = Av.reshape(rows, columns);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "reshape(int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testReshapeIntIntInt() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int slices = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int rows = 16;
        int columns = 4;
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DComplexMatrix3D B = ((DComplexMatrix1D)A).reshape(slices, rows, columns);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix1D)A).reshape(slices, rows, columns);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D Av = A.viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DComplexMatrix3D B = Av.reshape(slices, rows, columns);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = Av.reshape(slices, rows, columns);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "reshape(int, int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSwapDComplexMatrix1D() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        DenseDComplexMatrix1D B = new DenseDComplexMatrix1D(b);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix1D)A).swap(B);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                ((DComplexMatrix1D)A).swap(B);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D Av = A.viewFlip();
        B = new DenseDComplexMatrix1D(b);
        DComplexMatrix1D Bv = B.viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.swap(Bv);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                Av.swap(Bv);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "swap(DComplexMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArrayDoubleArray() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] array = A.toArray();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                array = A.toArray();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] array = Av.toArray();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                array = Av.toArray();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZDotProductDComplexMatrix1DIntInt() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        DenseDComplexMatrix1D B = new DenseDComplexMatrix1D(b);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] product = ((DComplexMatrix1D)A).zDotProduct(B, 5, (int)B.size() - 10);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                product = ((DComplexMatrix1D)A).zDotProduct(B, 5, (int)B.size() - 10);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D Av = A.viewFlip();
        B = new DenseDComplexMatrix1D(b);
        DComplexMatrix1D Bv = B.viewFlip();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] product = Av.zDotProduct(Bv, 5, (int)Bv.size() - 10);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                product = Av.zDotProduct(Bv, 5, (int)Bv.size() - 10);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "zDotProduct(DComplexMatrix1D, int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZSum() {
        DenseDComplexMatrix1D A = new DenseDComplexMatrix1D(a);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] aSum = ((DComplexMatrix1D)A).zSum();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = ((DComplexMatrix1D)A).zSum();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D Av = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] aSum = Av.zSum();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = Av.zSum();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }
}

