/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleIR
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D z;
    private DoubleMatrix1D r;

    public DoubleIR(DoubleMatrix1D template) {
        this.z = template.copy();
        this.r = template.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(A, b, x);
        A.zMult(x, this.r.assign(b), -1.0, 1.0, false);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            x.assign(this.z, DoubleFunctions.plus);
            A.zMult(x, this.r.assign(b), -1.0, 1.0, false);
            this.iter.next();
        }
        return x;
    }
}

