/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;

class SelectedDenseDoubleMatrix1D
extends DoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseDoubleMatrix1D(double[] elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedDenseDoubleMatrix1D(int size, double[] elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public double[] elements() {
        return this.elements;
    }

    public double getQuick(int index) {
        return this.elements[this.offset + this.offsets[this.zero + index * this.stride]];
    }

    public long index(int rank) {
        return this.offset + this.offsets[this.zero + rank * this.stride];
    }

    public DoubleMatrix1D like(int size) {
        return new DenseDoubleMatrix1D(size);
    }

    public DoubleMatrix2D like2D(int rows, int columns) {
        return new DenseDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix2D reshape(int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseDoubleMatrix2D M = new DenseDoubleMatrix2D(rows, columns);
        double[] elementsOther = (double[])((DoubleMatrix2D)M).elements();
        int zeroOther = (int)((AbstractMatrix2D)M).index(0, 0);
        int rowStrideOther = M.rowStride();
        int colStrideOther = M.columnStride();
        int idx = 0;
        for (int c = 0; c < columns; ++c) {
            int idxOther = zeroOther + c * colStrideOther;
            for (int r = 0; r < rows; ++r) {
                elementsOther[idxOther] = this.getQuick(idx++);
                idxOther += rowStrideOther;
            }
        }
        return M;
    }

    public DoubleMatrix3D reshape(int slices, int rows, int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseDoubleMatrix3D M = new DenseDoubleMatrix3D(slices, rows, columns);
        double[] elementsOther = (double[])((DoubleMatrix3D)M).elements();
        int zeroOther = (int)((AbstractMatrix3D)M).index(0, 0, 0);
        int sliceStrideOther = M.sliceStride();
        int rowStrideOther = M.rowStride();
        int colStrideOther = M.columnStride();
        int idx = 0;
        for (int s = 0; s < slices; ++s) {
            for (int c = 0; c < columns; ++c) {
                int idxOther = zeroOther + s * sliceStrideOther + c * colStrideOther;
                for (int r = 0; r < rows; ++r) {
                    elementsOther[idxOther] = this.getQuick(idx++);
                    idxOther += rowStrideOther;
                }
            }
        }
        return M;
    }

    public void setQuick(int index, double value) {
        this.elements[this.offset + this.offsets[this.zero + index * this.stride]] = value;
    }

    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        if (other instanceof SelectedDenseDoubleMatrix1D) {
            SelectedDenseDoubleMatrix1D otherMatrix = (SelectedDenseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDoubleMatrix1D) {
            DenseDoubleMatrix1D otherMatrix = (DenseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseDoubleMatrix1D(this.elements, offsets);
    }
}

