/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_1D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_1D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeFloatMatrix2D
extends WrapperFloatMatrix2D {
    private static final long serialVersionUID = 1L;
    private float[][] elements;
    private FloatFFT_2D fft2;
    private FloatDCT_2D dct2;
    private FloatDST_2D dst2;
    private FloatDHT_2D dht2;
    private FloatFFT_1D fftRows;
    private FloatFFT_1D fftColumns;
    private FloatDCT_1D dctRows;
    private FloatDCT_1D dctColumns;
    private FloatDST_1D dstRows;
    private FloatDST_1D dstColumns;
    private FloatDHT_1D dhtRows;
    private FloatDHT_1D dhtColumns;

    public DenseLargeFloatMatrix2D(int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new float[rows][columns];
        this.content = this;
    }

    public void dct2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        this.dct2.forward(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dctColumns(final boolean scale) {
        int nthreads;
        if (this.dctColumns == null) {
            this.dctColumns = new FloatDCT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastCol = j == nthreads - 1 ? this.columns : firstCol + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastCol; ++c) {
                            float[] column = (float[])DenseLargeFloatMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeFloatMatrix2D.this.dctColumns.forward(column, scale);
                            DenseLargeFloatMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                float[] column = (float[])this.viewColumn(c).copy().elements();
                this.dctColumns.forward(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void dctRows(final boolean scale) {
        int nthreads;
        if (this.dctRows == null) {
            this.dctRows = new FloatDCT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeFloatMatrix2D.this.dctRows.forward(DenseLargeFloatMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dctRows.forward(this.elements[r], scale);
            }
        }
    }

    public void dht2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        this.dht2.forward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtColumns() {
        int nthreads;
        if (this.dhtColumns == null) {
            this.dhtColumns = new FloatDHT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastCol = j == nthreads - 1 ? this.columns : firstCol + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastCol; ++c) {
                            float[] column = (float[])DenseLargeFloatMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeFloatMatrix2D.this.dhtColumns.forward(column);
                            DenseLargeFloatMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                float[] column = (float[])this.viewColumn(c).copy().elements();
                this.dhtColumns.forward(column);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void dhtRows() {
        int nthreads;
        if (this.dhtRows == null) {
            this.dhtRows = new FloatDHT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeFloatMatrix2D.this.dhtRows.forward(DenseLargeFloatMatrix2D.this.elements[r]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dhtRows.forward(this.elements[r]);
            }
        }
    }

    public void dst2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        this.dst2.forward(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dstColumns(final boolean scale) {
        int nthreads;
        if (this.dstColumns == null) {
            this.dstColumns = new FloatDST_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastCol = j == nthreads - 1 ? this.columns : firstCol + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastCol; ++c) {
                            float[] column = (float[])DenseLargeFloatMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeFloatMatrix2D.this.dstColumns.forward(column, scale);
                            DenseLargeFloatMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                float[] column = (float[])this.viewColumn(c).copy().elements();
                this.dstColumns.forward(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void dstRows(final boolean scale) {
        int nthreads;
        if (this.dstRows == null) {
            this.dstRows = new FloatDST_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeFloatMatrix2D.this.dstRows.forward(DenseLargeFloatMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dstRows.forward(this.elements[r], scale);
            }
        }
    }

    public void fft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public DenseLargeFComplexMatrix2D getFft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        DenseLargeFComplexMatrix2D C = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        final float[][] elementsC = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            System.arraycopy(DenseLargeFloatMatrix2D.this.elements[r], 0, elementsC[r], 0, DenseLargeFloatMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                System.arraycopy(this.elements[r], 0, elementsC[r], 0, this.columns);
            }
        }
        this.fft2.realForwardFull(elementsC);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeFComplexMatrix2D getFftColumns() {
        if (this.fftColumns == null) {
            this.fftColumns = new FloatFFT_1D(this.rows);
        }
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseLargeFComplexMatrix2D C = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstCol + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastColumn; ++c) {
                            float[] column = new float[2 * DenseLargeFloatMatrix2D.this.rows];
                            System.arraycopy(DenseLargeFloatMatrix2D.this.viewColumn(c).copy().elements(), 0, column, 0, DenseLargeFloatMatrix2D.this.rows);
                            DenseLargeFloatMatrix2D.this.fftColumns.realForwardFull(column);
                            C.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                float[] column = new float[2 * this.rows];
                System.arraycopy(this.viewColumn(c).copy().elements(), 0, column, 0, this.rows);
                this.fftColumns.realForwardFull(column);
                C.viewColumn(c).assign(column);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeFComplexMatrix2D getFftRows() {
        if (this.fftRows == null) {
            this.fftRows = new FloatFFT_1D(this.columns);
        }
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseLargeFComplexMatrix2D C = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            float[] row = new float[2 * DenseLargeFloatMatrix2D.this.columns];
                            System.arraycopy(DenseLargeFloatMatrix2D.this.elements[r], 0, row, 0, DenseLargeFloatMatrix2D.this.columns);
                            DenseLargeFloatMatrix2D.this.fftRows.realForwardFull(row);
                            C.viewRow(r).assign(row);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                float[] row = new float[2 * this.columns];
                System.arraycopy(this.elements[r], 0, row, 0, this.columns);
                this.fftRows.realForwardFull(row);
                C.viewRow(r).assign(row);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeFComplexMatrix2D getIfft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseLargeFComplexMatrix2D C = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        final float[][] elementsC = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            System.arraycopy(DenseLargeFloatMatrix2D.this.elements[r], 0, elementsC[r], 0, DenseLargeFloatMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                System.arraycopy(this.elements[r], 0, elementsC[r], 0, this.columns);
            }
        }
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverseFull(elementsC, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeFComplexMatrix2D getIfftColumns(final boolean scale) {
        if (this.fftColumns == null) {
            this.fftColumns = new FloatFFT_1D(this.rows);
        }
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseLargeFComplexMatrix2D C = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            float[] column = new float[2 * DenseLargeFloatMatrix2D.this.rows];
                            System.arraycopy(DenseLargeFloatMatrix2D.this.viewColumn(c).copy().elements(), 0, column, 0, DenseLargeFloatMatrix2D.this.rows);
                            DenseLargeFloatMatrix2D.this.fftColumns.realInverseFull(column, scale);
                            C.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                float[] column = new float[2 * this.rows];
                System.arraycopy(this.viewColumn(c).copy().elements(), 0, column, 0, this.rows);
                this.fftColumns.realInverseFull(column, scale);
                C.viewColumn(c).assign(column);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseLargeFComplexMatrix2D getIfftRows(final boolean scale) {
        if (this.fftRows == null) {
            this.fftRows = new FloatFFT_1D(this.columns);
        }
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseLargeFComplexMatrix2D C = new DenseLargeFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            float[] row = new float[2 * DenseLargeFloatMatrix2D.this.columns];
                            System.arraycopy(DenseLargeFloatMatrix2D.this.elements[r], 0, row, 0, DenseLargeFloatMatrix2D.this.columns);
                            DenseLargeFloatMatrix2D.this.fftRows.realInverseFull(row, scale);
                            C.viewRow(r).assign(row);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                float[] row = new float[2 * this.columns];
                System.arraycopy(this.elements[r], 0, row, 0, this.columns);
                this.fftRows.realInverseFull(row, scale);
                C.viewRow(r).assign(row);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public float getQuick(int row, int column) {
        return this.elements[row][column];
    }

    public void idct2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        this.dct2.inverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idctColumns(final boolean scale) {
        int nthreads;
        if (this.dctColumns == null) {
            this.dctColumns = new FloatDCT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            float[] column = (float[])DenseLargeFloatMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeFloatMatrix2D.this.dctColumns.inverse(column, scale);
                            DenseLargeFloatMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                float[] column = (float[])this.viewColumn(c).copy().elements();
                this.dctColumns.inverse(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void idctRows(final boolean scale) {
        int nthreads;
        if (this.dctRows == null) {
            this.dctRows = new FloatDCT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeFloatMatrix2D.this.dctRows.inverse(DenseLargeFloatMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dctRows.inverse(this.elements[r], scale);
            }
        }
    }

    public void idht2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        this.dht2.inverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtColumns(final boolean scale) {
        int nthreads;
        if (this.dhtColumns == null) {
            this.dhtColumns = new FloatDHT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            float[] column = (float[])DenseLargeFloatMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeFloatMatrix2D.this.dhtColumns.inverse(column, scale);
                            DenseLargeFloatMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                float[] column = (float[])this.viewColumn(c).copy().elements();
                this.dhtColumns.inverse(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void idhtRows(final boolean scale) {
        int nthreads;
        if (this.dhtRows == null) {
            this.dhtRows = new FloatDHT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeFloatMatrix2D.this.dhtRows.inverse(DenseLargeFloatMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dhtRows.inverse(this.elements[r], scale);
            }
        }
    }

    public void idst2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        this.dst2.inverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idstColumns(final boolean scale) {
        int nthreads;
        if (this.dstColumns == null) {
            this.dstColumns = new FloatDST_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            float[] column = (float[])DenseLargeFloatMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeFloatMatrix2D.this.dstColumns.inverse(column, scale);
                            DenseLargeFloatMatrix2D.this.viewColumn(c).assign(column);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                float[] column = (float[])this.viewColumn(c).copy().elements();
                this.dstColumns.inverse(column, scale);
                this.viewColumn(c).assign(column);
            }
        }
    }

    public void idstRows(final boolean scale) {
        int nthreads;
        if (this.dstRows == null) {
            this.dstRows = new FloatDST_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DenseLargeFloatMatrix2D.this.dstRows.inverse(DenseLargeFloatMatrix2D.this.elements[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.dstRows.inverse(this.elements[r], scale);
            }
        }
    }

    public void ifft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void setQuick(int row, int column, float value) {
        this.elements[row][column] = value;
    }

    public float[][] elements() {
        return this.elements;
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    public FloatMatrix2D like(int rows, int columns) {
        return new DenseLargeFloatMatrix2D(rows, columns);
    }

    public FloatMatrix1D like1D(int size) {
        return new DenseFloatMatrix1D(size);
    }
}

