/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.map.tlong.AbstractLongLongMap;
import cern.colt.map.tlong.OpenLongLongHashMap;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.SelectedSparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix3D;

public class SparseLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongLongMap elements;

    public SparseLongMatrix1D(long[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseLongMatrix1D(int size) {
        this(size, size / 1000, 0.2, 0.5);
    }

    public SparseLongMatrix1D(int size, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(size);
        this.elements = new OpenLongLongHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseLongMatrix1D(int size, AbstractLongLongMap elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    public LongMatrix1D assign(long value) {
        if (this.isNoView && value == 0L) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongLongMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    public synchronized long getQuick(int index) {
        return this.elements.get((long)this.zero + (long)index * (long)this.stride);
    }

    public long index(int rank) {
        return (long)this.zero + (long)rank * (long)this.stride;
    }

    public LongMatrix1D like(int size) {
        return new SparseLongMatrix1D(size);
    }

    public LongMatrix2D like2D(int rows, int columns) {
        return new SparseLongMatrix2D(rows, columns);
    }

    public LongMatrix2D reshape(int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseLongMatrix2D M = new SparseLongMatrix2D(rows, columns);
        int idx = 0;
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                long elem;
                if ((elem = this.getQuick(idx++)) == 0L) continue;
                ((LongMatrix2D)M).setQuick(r, c, elem);
            }
        }
        return M;
    }

    public LongMatrix3D reshape(int slices, int rows, int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseLongMatrix3D M = new SparseLongMatrix3D(slices, rows, columns);
        int idx = 0;
        for (int s = 0; s < slices; ++s) {
            for (int c = 0; c < columns; ++c) {
                for (int r = 0; r < rows; ++r) {
                    long elem;
                    if ((elem = this.getQuick(idx++)) == 0L) continue;
                    ((LongMatrix3D)M).setQuick(s, r, c, elem);
                }
            }
        }
        return M;
    }

    public synchronized void setQuick(int index, long value) {
        long i = (long)this.zero + (long)index * (long)this.stride;
        if (value == 0L) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("1 x ").append(this.size).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.size; ++i) {
            long elem = this.getQuick(i);
            if (elem == 0L) continue;
            builder.append('(').append(i).append(')').append('\t').append(elem).append('\n');
        }
        return builder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected boolean haveSharedCellsRaw(LongMatrix1D other) {
        if (other instanceof SelectedSparseLongMatrix1D) {
            SelectedSparseLongMatrix1D otherMatrix = (SelectedSparseLongMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseLongMatrix1D) {
            SparseLongMatrix1D otherMatrix = (SparseLongMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected LongMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseLongMatrix1D(this.elements, offsets);
    }
}

