/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.ref.FloatHistogram;

abstract class FloatAbstractHistogram1D
extends FloatHistogram
implements FloatIHistogram1D {
    private static final long serialVersionUID = 1L;
    protected FloatIAxis xAxis;

    FloatAbstractHistogram1D(String title) {
        super(title);
    }

    public int allEntries() {
        return this.entries() + this.extraEntries();
    }

    public int dimensions() {
        return 1;
    }

    public int entries() {
        int entries = 0;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            entries += this.binEntries(i);
        }
        return entries;
    }

    public int extraEntries() {
        return this.binEntries(-2) + this.binEntries(-1);
    }

    int map(int index) {
        int bins = this.xAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    public int[] minMaxBins() {
        float minValue = Float.MAX_VALUE;
        float maxValue = Float.MIN_VALUE;
        int minBinX = -1;
        int maxBinX = -1;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            float value = this.binHeight(i);
            if (value < minValue) {
                minValue = value;
                minBinX = i;
            }
            if (!(value > maxValue)) continue;
            maxValue = value;
            maxBinX = i;
        }
        int[] result = new int[]{minBinX, maxBinX};
        return result;
    }

    public float sumAllBinHeights() {
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    public float sumBinHeights() {
        float sum = 0.0f;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            sum += this.binHeight(i);
        }
        return sum;
    }

    public float sumExtraBinHeights() {
        return this.binHeight(-2) + this.binHeight(-1);
    }

    public FloatIAxis xAxis() {
        return this.xAxis;
    }
}

