/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.Scalar;

public class QuaternionArray
extends ReferenceTypeArray<Quaternion> {
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(Quaternion.class);
    static final DenseArray.DenseFactory<Quaternion> FACTORY = new DenseArray.DenseFactory<Quaternion>(){

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        DenseArray<Quaternion> make(int size) {
            return QuaternionArray.make(size);
        }

        @Override
        Scalar<Quaternion> zero() {
            return Quaternion.ZERO;
        }
    };

    public static final QuaternionArray make(int size) {
        return new QuaternionArray(size);
    }

    public static final SegmentedArray<Quaternion> makeSegmented(long count) {
        return SegmentedArray.make(FACTORY, count);
    }

    public static final QuaternionArray wrap(Quaternion[] data) {
        return new QuaternionArray(data);
    }

    protected QuaternionArray(int size) {
        super((Number[])new Quaternion[size]);
        this.fill(0, size, 1, Quaternion.ZERO);
    }

    protected QuaternionArray(Quaternion[] data) {
        super((Number[])data);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof QuaternionArray) {
            return Arrays.equals(this.data, ((QuaternionArray)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public final void fillMatching(Access1D<?> values) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            ((Quaternion[])this.data)[i] = Quaternion.valueOf(values.get(i));
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((Quaternion)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, Number addend) {
        this.fillOne(index, ((Quaternion)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected int indexOfLargest(int first, int limit, int step) {
        int retVal = first;
        double tmpLargest = PrimitiveMath.ZERO;
        for (int i = first; i < limit; i += step) {
            double tmpValue = ((Quaternion[])this.data)[i].norm();
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    protected boolean isAbsolute(int index) {
        return Quaternion.isAbsolute(((Quaternion[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return Quaternion.isSmall(comparedTo, ((Quaternion[])this.data)[index]);
    }

    @Override
    DenseArray<Quaternion> newInstance(int capacity) {
        return new QuaternionArray(capacity);
    }

    @Override
    final Quaternion valueOf(double value) {
        return Quaternion.valueOf(value);
    }

    @Override
    final Quaternion valueOf(Number number) {
        return Quaternion.valueOf(number);
    }
}

