/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.scalar.Scalar;

abstract class ScalarArray<N extends Number>
extends ReferenceTypeArray<N> {
    protected ScalarArray(N[] data) {
        super(data);
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        int retVal = first;
        double tmpLargest = PrimitiveMath.ZERO;
        for (int i = first; i < limit; i += step) {
            double tmpValue = ((NormedVectorSpace)((Object)this.data[i])).norm();
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    protected boolean isAbsolute(int index) {
        return ((Scalar)((Object)this.data[index])).isAbsolute();
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return ((NormedVectorSpace)((Object)this.data[index])).isSmall(comparedTo);
    }
}

