/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.type.TypeUtils;

public final class QuaternionFunction
extends FunctionSet<Quaternion> {
    public static final UnaryFunction<Quaternion> ABS = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return Quaternion.valueOf(arg.norm());
        }
    };
    public static final UnaryFunction<Quaternion> ACOS = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg.getPureVersor().negate().multiply(ACOSH.invoke(arg));
        }
    };
    public static final UnaryFunction<Quaternion> ACOSH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return LOG.invoke(arg.add(SQRT.invoke(arg.multiply(arg).subtract(PrimitiveMath.ONE))));
        }
    };
    public static final BinaryFunction<Quaternion> ADD = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return arg1.add(arg2);
        }
    };
    public static final UnaryFunction<Quaternion> ASIN = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpNmbr = SQRT.invoke(Quaternion.ONE.subtract(POWER.invoke(arg, 2)));
            Quaternion aNumber = tmpNmbr = Quaternion.I.multiply(arg).add(tmpNmbr);
            return LOG.invoke(aNumber).multiply(Quaternion.I).negate();
        }
    };
    public static final UnaryFunction<Quaternion> ASINH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpNmbr = arg.multiply(arg).add(PrimitiveMath.ONE);
            return LOG.invoke(arg.add(SQRT.invoke(tmpNmbr)));
        }
    };
    public static final UnaryFunction<Quaternion> ATAN = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpNmbr = Quaternion.I.add(arg).divide(Quaternion.I.subtract(arg));
            return LOG.invoke(tmpNmbr).multiply(Quaternion.I).divide(PrimitiveMath.TWO);
        }
    };
    public static final UnaryFunction<Quaternion> ATANH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpNmbr = arg.add(PrimitiveMath.ONE).divide(Quaternion.ONE.subtract(arg));
            return LOG.invoke(tmpNmbr).divide(PrimitiveMath.TWO);
        }
    };
    public static final UnaryFunction<Quaternion> CARDINALITY = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return TypeUtils.isZero(arg.norm()) ? Quaternion.ZERO : Quaternion.ONE;
        }
    };
    public static final UnaryFunction<Quaternion> CONJUGATE = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg.conjugate();
        }
    };
    public static final UnaryFunction<Quaternion> COS = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return COSH.invoke(arg.multiply(Quaternion.I));
        }
    };
    public static final UnaryFunction<Quaternion> COSH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return EXP.invoke(arg).add(EXP.invoke(arg.negate())).divide(PrimitiveMath.TWO);
        }
    };
    public static final BinaryFunction<Quaternion> DIVIDE = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return arg1.divide(arg2);
        }
    };
    public static final UnaryFunction<Quaternion> EXP = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            if (arg.isReal()) {
                double tmpScalar = Math.exp(arg.scalar());
                return Quaternion.valueOf(tmpScalar);
            }
            double tmpNorm = Math.exp(arg.scalar());
            double[] tmpUnit = arg.unit();
            double tmpPhase = arg.getVectorLength();
            return Quaternion.makePolar(tmpNorm, tmpUnit, tmpPhase);
        }
    };
    public static final UnaryFunction<Quaternion> EXPM1 = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return EXP.invoke(arg).subtract(1.0);
        }
    };
    public static final BinaryFunction<Quaternion> HYPOT = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return Quaternion.valueOf(Math.hypot(arg1.norm(), arg2.norm()));
        }
    };
    public static final UnaryFunction<Quaternion> INVERT = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return POWER.invoke(arg, -1);
        }
    };
    public static final UnaryFunction<Quaternion> LOG = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            double tmpNorm = arg.norm();
            double[] tmpUnitVector = arg.unit();
            double tmpPhase = Math.acos(arg.scalar() / tmpNorm);
            double tmpScalar = Math.log(tmpNorm);
            double tmpI = tmpUnitVector[0] * tmpPhase;
            double tmpJ = tmpUnitVector[1] * tmpPhase;
            double tmpK = tmpUnitVector[2] * tmpPhase;
            return Quaternion.of(tmpScalar, tmpI, tmpJ, tmpK);
        }
    };
    public static final UnaryFunction<Quaternion> LOG10 = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return LOG.invoke(arg).divide(PrimitiveFunction.LOG.invoke(10.0));
        }
    };
    public static final UnaryFunction<Quaternion> LOG1P = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return LOG.invoke(arg.add(1.0));
        }
    };
    public static final BinaryFunction<Quaternion> MAX = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            Quaternion retVal = null;
            retVal = arg1.norm() >= arg2.norm() ? arg1 : arg2;
            return retVal;
        }
    };
    public static final BinaryFunction<Quaternion> MIN = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            Quaternion retVal = null;
            retVal = arg1.norm() <= arg2.norm() ? arg1 : arg2;
            return retVal;
        }
    };
    public static final BinaryFunction<Quaternion> MULTIPLY = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return arg1.multiply(arg2);
        }
    };
    public static final UnaryFunction<Quaternion> NEGATE = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg.negate();
        }
    };
    public static final BinaryFunction<Quaternion> POW = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return EXP.invoke(LOG.invoke(arg1).multiply(arg2));
        }
    };
    public static final ParameterFunction<Quaternion> POWER = new Parameter(){

        @Override
        public final Quaternion invoke(Quaternion arg, int param) {
            Quaternion tmpInvoke = LOG.invoke(arg);
            Quaternion tmpMultiply = tmpInvoke.multiply(param);
            return EXP.invoke(tmpMultiply);
        }
    };
    public static final ParameterFunction<Quaternion> ROOT = new Parameter(){

        @Override
        public final Quaternion invoke(Quaternion arg, int param) {
            if (param != 0) {
                return EXP.invoke(LOG.invoke(arg).divide(param));
            }
            throw new IllegalArgumentException();
        }
    };
    public static final ParameterFunction<Quaternion> SCALE = new Parameter(){

        @Override
        public final Quaternion invoke(Quaternion arg, int param) {
            double tmpScalar = PrimitiveFunction.SCALE.invoke(arg.scalar(), param);
            double tmpI = PrimitiveFunction.SCALE.invoke(arg.i, param);
            double tmpJ = PrimitiveFunction.SCALE.invoke(arg.j, param);
            double tmpK = PrimitiveFunction.SCALE.invoke(arg.k, param);
            return Quaternion.of(tmpScalar, tmpI, tmpJ, tmpK);
        }
    };
    public static final UnaryFunction<Quaternion> SIGNUM = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg.signum();
        }
    };
    public static final UnaryFunction<Quaternion> SIN = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return SINH.invoke(arg.multiply(Quaternion.I)).multiply(Quaternion.I.negate());
        }
    };
    public static final UnaryFunction<Quaternion> SINH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return EXP.invoke(arg).subtract(EXP.invoke(arg.negate())).divide(PrimitiveMath.TWO);
        }
    };
    public static final UnaryFunction<Quaternion> SQRT = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return ROOT.invoke(arg, 2);
        }
    };
    public static final UnaryFunction<Quaternion> SQRT1PX2 = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return SQRT.invoke(Quaternion.ONE.add(arg.multiply(arg)));
        }
    };
    public static final BinaryFunction<Quaternion> SUBTRACT = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return arg1.subtract(arg2);
        }
    };
    public static final UnaryFunction<Quaternion> TAN = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return TANH.invoke(arg.multiply(Quaternion.I)).multiply(Quaternion.I.negate());
        }
    };
    public static final UnaryFunction<Quaternion> TANH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpDivisor;
            Quaternion tmpMinus;
            Quaternion tmpPlus = EXP.invoke(arg);
            Quaternion tmpDividend = tmpPlus.subtract(tmpMinus = EXP.invoke(arg.negate()));
            Quaternion retVal = tmpDividend.equals(tmpDivisor = tmpPlus.add(tmpMinus)) ? Quaternion.ONE : (tmpDividend.equals(tmpDivisor.negate()) ? Quaternion.ONE.negate() : tmpDividend.divide(tmpDivisor));
            return retVal;
        }
    };
    public static final UnaryFunction<Quaternion> VALUE = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg;
        }
    };
    private static final double _1_0 = 1.0;
    private static final QuaternionFunction SET = new QuaternionFunction();

    public static QuaternionFunction getSet() {
        return SET;
    }

    private QuaternionFunction() {
    }

    @Override
    public UnaryFunction<Quaternion> abs() {
        return ABS;
    }

    @Override
    public UnaryFunction<Quaternion> acos() {
        return ACOS;
    }

    @Override
    public UnaryFunction<Quaternion> acosh() {
        return ACOSH;
    }

    @Override
    public BinaryFunction<Quaternion> add() {
        return ADD;
    }

    @Override
    public UnaryFunction<Quaternion> asin() {
        return ASIN;
    }

    @Override
    public UnaryFunction<Quaternion> asinh() {
        return ASINH;
    }

    @Override
    public UnaryFunction<Quaternion> atan() {
        return ATAN;
    }

    @Override
    public UnaryFunction<Quaternion> atanh() {
        return ATANH;
    }

    @Override
    public UnaryFunction<Quaternion> cardinality() {
        return CARDINALITY;
    }

    @Override
    public UnaryFunction<Quaternion> conjugate() {
        return CONJUGATE;
    }

    @Override
    public UnaryFunction<Quaternion> cos() {
        return COS;
    }

    @Override
    public UnaryFunction<Quaternion> cosh() {
        return COSH;
    }

    @Override
    public BinaryFunction<Quaternion> divide() {
        return DIVIDE;
    }

    @Override
    public UnaryFunction<Quaternion> exp() {
        return EXP;
    }

    @Override
    public UnaryFunction<Quaternion> expm1() {
        return EXPM1;
    }

    @Override
    public BinaryFunction<Quaternion> hypot() {
        return HYPOT;
    }

    @Override
    public UnaryFunction<Quaternion> invert() {
        return INVERT;
    }

    @Override
    public UnaryFunction<Quaternion> log() {
        return LOG;
    }

    @Override
    public UnaryFunction<Quaternion> log10() {
        return LOG10;
    }

    @Override
    public UnaryFunction<Quaternion> log1p() {
        return LOG1P;
    }

    @Override
    public BinaryFunction<Quaternion> max() {
        return MAX;
    }

    @Override
    public BinaryFunction<Quaternion> min() {
        return MIN;
    }

    @Override
    public BinaryFunction<Quaternion> multiply() {
        return MULTIPLY;
    }

    @Override
    public UnaryFunction<Quaternion> negate() {
        return NEGATE;
    }

    @Override
    public BinaryFunction<Quaternion> pow() {
        return POW;
    }

    @Override
    public ParameterFunction<Quaternion> power() {
        return POWER;
    }

    @Override
    public ParameterFunction<Quaternion> root() {
        return ROOT;
    }

    @Override
    public ParameterFunction<Quaternion> scale() {
        return SCALE;
    }

    @Override
    public UnaryFunction<Quaternion> signum() {
        return SIGNUM;
    }

    @Override
    public UnaryFunction<Quaternion> sin() {
        return SIN;
    }

    @Override
    public UnaryFunction<Quaternion> sinh() {
        return SINH;
    }

    @Override
    public UnaryFunction<Quaternion> sqrt() {
        return SQRT;
    }

    @Override
    public UnaryFunction<Quaternion> sqrt1px2() {
        return SQRT1PX2;
    }

    @Override
    public BinaryFunction<Quaternion> subtract() {
        return SUBTRACT;
    }

    @Override
    public UnaryFunction<Quaternion> tan() {
        return TAN;
    }

    @Override
    public UnaryFunction<Quaternion> tanh() {
        return TANH;
    }

    @Override
    public UnaryFunction<Quaternion> value() {
        return VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<Quaternion> {
        @Override
        default public double invoke(double arg) {
            return this.invoke(Quaternion.valueOf(arg)).doubleValue();
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<Quaternion> {
        @Override
        default public double invoke(double arg, int param) {
            return this.invoke(Quaternion.valueOf(arg), param).doubleValue();
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<Quaternion> {
        @Override
        default public double invoke(double arg1, double arg2) {
            return this.invoke(Quaternion.valueOf(arg1), Quaternion.valueOf(arg2)).doubleValue();
        }
    }
}

