/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

public abstract class PrimitiveAggregator {
    public static final ThreadLocal<AggregatorFunction<Double>> CARDINALITY = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private int myCount = 0;

                @Override
                public double doubleValue() {
                    return this.myCount;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(double anArg) {
                    if (!TypeUtils.isZero(anArg)) {
                        ++this.myCount;
                    }
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.myCount += result.intValue();
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return result1.intValue() + result2.intValue();
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myCount = 0;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> LARGEST = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue = Math.max(this.myValue, Math.abs(anArg));
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.invoke((double)result);
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return Math.max(result1, result2);
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> MAX = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue = Math.max(this.myValue, anArg);
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.invoke((double)result);
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return Math.max(result1, result2);
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> MIN = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = Double.POSITIVE_INFINITY;

                @Override
                public double doubleValue() {
                    if (Double.isInfinite(this.myValue)) {
                        return PrimitiveMath.ZERO;
                    }
                    return this.myValue;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue = Math.min(this.myValue, anArg);
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.invoke((double)result);
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return Math.min(result1, result2);
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = Double.POSITIVE_INFINITY;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> NORM1 = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue += Math.abs(anArg);
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.invoke((double)result);
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return Math.abs(result1) + Math.abs(result2);
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> NORM2 = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return Math.sqrt(this.myValue);
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue += anArg * anArg;
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.invoke((double)result);
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return Math.hypot(result1, result2);
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> PRODUCT = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = PrimitiveMath.ONE;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue *= anArg;
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.invoke((double)result);
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return result1 * result2;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ONE;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> PRODUCT2 = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = PrimitiveMath.ONE;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue *= anArg * anArg;
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.myValue *= result.doubleValue();
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return result1 * result2;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ONE;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> SMALLEST = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = Double.POSITIVE_INFINITY;

                @Override
                public double doubleValue() {
                    if (Double.isInfinite(this.myValue)) {
                        return PrimitiveMath.ZERO;
                    }
                    return this.myValue;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    double tmpArg = Math.abs(anArg);
                    if (tmpArg != PrimitiveMath.ZERO) {
                        this.myValue = Math.min(this.myValue, tmpArg);
                    }
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.invoke((double)result);
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return Math.min(result1, result2);
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = Double.POSITIVE_INFINITY;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> SUM = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue += anArg;
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.invoke((double)result);
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return result1 + result2;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<Double>> SUM2 = new ThreadLocal<AggregatorFunction<Double>>(){

        @Override
        protected AggregatorFunction<Double> initialValue() {
            return new AggregatorFunction<Double>(){
                private double myValue = PrimitiveMath.ZERO;

                @Override
                public double doubleValue() {
                    return this.myValue;
                }

                @Override
                public Double getNumber() {
                    return this.doubleValue();
                }

                @Override
                public int intValue() {
                    return (int)this.doubleValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.myValue += anArg * anArg;
                }

                @Override
                public void invoke(Double anArg) {
                    this.invoke((double)anArg);
                }

                @Override
                public void merge(Double result) {
                    this.myValue += result.doubleValue();
                }

                @Override
                public Double merge(Double result1, Double result2) {
                    return result1 + result2;
                }

                @Override
                public AggregatorFunction<Double> reset() {
                    this.myValue = PrimitiveMath.ZERO;
                    return this;
                }

                @Override
                public Scalar<Double> toScalar() {
                    return PrimitiveScalar.of(this.doubleValue());
                }
            };
        }
    };
    private static final AggregatorSet<Double> SET = new AggregatorSet<Double>(){

        @Override
        public AggregatorFunction<Double> cardinality() {
            return CARDINALITY.get().reset();
        }

        @Override
        public AggregatorFunction<Double> largest() {
            return LARGEST.get().reset();
        }

        @Override
        public AggregatorFunction<Double> maximum() {
            return MAX.get().reset();
        }

        @Override
        public AggregatorFunction<Double> minimum() {
            return MIN.get().reset();
        }

        @Override
        public AggregatorFunction<Double> norm1() {
            return NORM1.get().reset();
        }

        @Override
        public AggregatorFunction<Double> norm2() {
            return NORM2.get().reset();
        }

        @Override
        public AggregatorFunction<Double> product() {
            return PRODUCT.get().reset();
        }

        @Override
        public AggregatorFunction<Double> product2() {
            return PRODUCT2.get().reset();
        }

        @Override
        public AggregatorFunction<Double> smallest() {
            return SMALLEST.get().reset();
        }

        @Override
        public AggregatorFunction<Double> sum() {
            return SUM.get().reset();
        }

        @Override
        public AggregatorFunction<Double> sum2() {
            return SUM2.get().reset();
        }
    };

    @Deprecated
    public static AggregatorSet<Double> getCollection() {
        return PrimitiveAggregator.getSet();
    }

    public static AggregatorSet<Double> getSet() {
        return SET;
    }

    private PrimitiveAggregator() {
        ProgrammingError.throwForIllegalInvocation();
    }
}

