/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.RationalFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

public abstract class RationalAggregator {
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> CARDINALITY = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private int myCount = 0;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    return RationalNumber.valueOf(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    if (!TypeUtils.isZero(Math.abs(anArg.doubleValue()))) {
                        ++this.myCount;
                    }
                }

                @Override
                public void merge(RationalNumber result) {
                    this.myCount += result.intValue();
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myCount = 0;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> LARGEST = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = RationalFunction.MAX.invoke(this.myNumber, RationalFunction.ABS.invoke(anArg));
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MAX.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> MAX = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = RationalFunction.MAX.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MAX.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> MIN = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.POSITIVE_INFINITY;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    if (RationalNumber.isInfinite(this.myNumber)) {
                        return RationalNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = RationalFunction.MIN.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.POSITIVE_INFINITY;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> NORM1 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.add(Math.abs(anArg.doubleValue()));
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> NORM2 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    return RationalNumber.valueOf(Math.sqrt(Math.abs(this.myNumber.doubleValue())));
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    double tmpMod = Math.abs(anArg.doubleValue());
                    this.myNumber = this.myNumber.add(tmpMod * tmpMod);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.HYPOT.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> PRODUCT = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.ONE;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ONE;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> PRODUCT2 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.ONE;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg.multiply(anArg));
                }

                @Override
                public void merge(RationalNumber result) {
                    this.myNumber = this.myNumber.multiply(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ONE;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> SMALLEST = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.POSITIVE_INFINITY;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    if (RationalNumber.isInfinite(this.myNumber)) {
                        return RationalNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    if (!RationalNumber.isSmall(PrimitiveMath.ONE, anArg)) {
                        this.myNumber = RationalFunction.MIN.invoke(this.myNumber, RationalFunction.ABS.invoke(anArg));
                    }
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.POSITIVE_INFINITY;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> SUM = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public void merge(RationalNumber result) {
                    this.invoke(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<RationalNumber>> SUM2 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new AggregatorFunction<RationalNumber>(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public double doubleValue() {
                    return this.getNumber().doubleValue();
                }

                @Override
                public RationalNumber getNumber() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.getNumber().intValue();
                }

                @Override
                public void invoke(double anArg) {
                    this.invoke(RationalNumber.valueOf(anArg));
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg.multiply(anArg));
                }

                @Override
                public void merge(RationalNumber result) {
                    this.myNumber = this.myNumber.add(result);
                }

                @Override
                public RationalNumber merge(RationalNumber result1, RationalNumber result2) {
                    return RationalFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }

                @Override
                public Scalar<RationalNumber> toScalar() {
                    return this.getNumber();
                }
            };
        }
    };
    private static final AggregatorSet<RationalNumber> SET = new AggregatorSet<RationalNumber>(){

        @Override
        public AggregatorFunction<RationalNumber> cardinality() {
            return CARDINALITY.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> largest() {
            return LARGEST.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> maximum() {
            return MAX.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> minimum() {
            return MIN.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> norm1() {
            return NORM1.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> norm2() {
            return NORM2.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> product() {
            return PRODUCT.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> product2() {
            return PRODUCT2.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> smallest() {
            return SMALLEST.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> sum() {
            return SUM.get().reset();
        }

        @Override
        public AggregatorFunction<RationalNumber> sum2() {
            return SUM2.get().reset();
        }
    };

    @Deprecated
    public static AggregatorSet<RationalNumber> getCollection() {
        return RationalAggregator.getSet();
    }

    public static AggregatorSet<RationalNumber> getSet() {
        return SET;
    }

    private RationalAggregator() {
        ProgrammingError.throwForIllegalInvocation();
    }
}

