/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import org.ojalgo.machine.BasicMachine;
import org.ojalgo.machine.Hardware;
import org.ojalgo.type.IntCount;

abstract class AbstractMachine
extends BasicMachine {
    static final long K = 1024L;
    public final String architecture;
    public final long cache;
    public final int cores;
    public final int units;

    static long elements(long availableMemory, long elementSize) {
        return (availableMemory - 16L) / elementSize;
    }

    private AbstractMachine(long memory, int threads) {
        super(memory, threads);
        throw new IllegalArgumentException();
    }

    protected AbstractMachine(Hardware hardware, Runtime runtime) {
        super(runtime.maxMemory(), runtime.availableProcessors());
        this.architecture = hardware.architecture;
        this.cache = hardware.cache;
        this.cores = hardware.cores;
        this.units = hardware.units;
    }

    protected AbstractMachine(String architecture, BasicMachine[] levels) {
        super(levels[0].memory, levels[0].threads);
        this.architecture = architecture;
        this.cores = this.threads / levels[levels.length - 1].threads;
        if (levels.length > 3) {
            this.cache = levels[levels.length - 3].memory;
            this.units = this.threads / levels[levels.length - 3].threads;
        } else if (levels.length > 2) {
            this.cache = levels[levels.length - 2].memory;
            this.units = this.threads / levels[levels.length - 2].threads;
        } else {
            this.cache = levels[levels.length - 1].memory;
            this.units = this.threads / levels[levels.length - 1].threads;
        }
    }

    public IntCount countCores() {
        return new IntCount(this.cores);
    }

    public IntCount countThreads() {
        return new IntCount(this.threads);
    }

    public IntCount countUnits() {
        return new IntCount(this.units);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractMachine)) {
            return false;
        }
        AbstractMachine other = (AbstractMachine)obj;
        if (this.architecture == null ? other.architecture != null : !this.architecture.equals(other.architecture)) {
            return false;
        }
        if (this.cache != other.cache) {
            return false;
        }
        if (this.units != other.units) {
            return false;
        }
        return this.units == other.units;
    }

    public int getCacheDim1D(long elementSize) {
        return (int)AbstractMachine.elements(this.cache, elementSize);
    }

    public int getCacheDim2D(long elementSize) {
        return (int)Math.sqrt(AbstractMachine.elements(this.cache, elementSize));
    }

    public int getMemoryDim1D(long elementSize) {
        return (int)AbstractMachine.elements(this.memory, elementSize);
    }

    public int getMemoryDim2D(long elementSize) {
        return (int)Math.sqrt(AbstractMachine.elements(this.memory, elementSize));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.architecture == null ? 0 : this.architecture.hashCode());
        result = 31 * result + (int)(this.cache ^ this.cache >>> 32);
        result = 31 * result + this.units;
        return result;
    }

    public boolean isMultiCore() {
        return this.cores > 1;
    }

    public boolean isMultiThread() {
        return this.threads > 1;
    }

    public boolean isMultiUnit() {
        return this.units > 1;
    }
}

