/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.util.List;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;

final class DiagonalAccess<N extends Number>
implements Access2D<N> {
    private final int myDimension;
    private final N myZero;
    final Array1D<N> mainDiagonal;
    final Array1D<N> subdiagonal;
    final Array1D<N> superdiagonal;

    private DiagonalAccess() {
        this(null, null, null, null);
    }

    DiagonalAccess(Array1D<N> aMainDiagonal, Array1D<N> aSuperdiagonal, Array1D<N> aSubdiagonal, N aZero) {
        this.mainDiagonal = aMainDiagonal;
        this.superdiagonal = aSuperdiagonal;
        this.subdiagonal = aSubdiagonal;
        this.myZero = aZero;
        this.myDimension = aMainDiagonal != null ? aMainDiagonal.size() : (aSuperdiagonal != null ? aSuperdiagonal.size() + 1 : aSubdiagonal.size() + 1);
    }

    @Override
    public long count() {
        return (int)this.count();
    }

    @Override
    public long countColumns() {
        return this.myDimension;
    }

    @Override
    public long countRows() {
        return this.myDimension;
    }

    @Override
    public double doubleValue(long anInd) {
        return this.doubleValue(AccessUtils.row((int)anInd, this.myDimension), AccessUtils.column((int)anInd, this.myDimension));
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        if (this.mainDiagonal != null && aRow == aCol) {
            return this.mainDiagonal.doubleValue(aRow);
        }
        if (this.superdiagonal != null && aCol - aRow == 1L) {
            return this.superdiagonal.doubleValue(aRow);
        }
        if (this.subdiagonal != null && aRow - aCol == 1L) {
            return this.subdiagonal.doubleValue(aCol);
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public N get(long index) {
        return this.get(AccessUtils.row(index, this.myDimension), AccessUtils.column(index, this.myDimension));
    }

    @Override
    public N get(long aRow, long aCol) {
        if (this.mainDiagonal != null && aRow == aCol) {
            return this.mainDiagonal.get(aRow);
        }
        if (this.superdiagonal != null && aCol - aRow == 1L) {
            return this.superdiagonal.get(aRow);
        }
        if (this.subdiagonal != null && aRow - aCol == 1L) {
            return this.subdiagonal.get(aCol);
        }
        return this.myZero;
    }

    public String toString() {
        return "DiagonalAccess [mainDiagonal=" + this.mainDiagonal + ", subdiagonal=" + this.subdiagonal + ", superdiagonal=" + this.superdiagonal + "]";
    }

    DiagonalAccess<N> columns(int first, int limit) {
        List tmpMainDiagonal = this.mainDiagonal != null ? this.mainDiagonal.subList(first, limit) : null;
        List tmpSuperdiagonal = this.superdiagonal != null ? this.superdiagonal.subList(Math.max(first - 1, 0), limit - 1) : null;
        List tmpSubdiagonal = this.subdiagonal != null ? this.subdiagonal.subList(first, Math.min(limit, this.myDimension - 1)) : null;
        return new DiagonalAccess<N>(tmpMainDiagonal, tmpSuperdiagonal, tmpSubdiagonal, this.myZero);
    }

    int getDimension() {
        return this.myDimension;
    }

    DiagonalAccess<N> rows(int first, int limit) {
        List tmpMainDiagonal = this.mainDiagonal != null ? this.mainDiagonal.subList(first, limit) : null;
        List tmpSuperdiagonal = this.superdiagonal != null ? this.superdiagonal.subList(first, Math.min(limit, this.myDimension - 1)) : null;
        List tmpSubdiagonal = this.subdiagonal != null ? this.subdiagonal.subList(Math.max(first - 1, 0), limit - 1) : null;
        return new DiagonalAccess<N>(tmpMainDiagonal, tmpSuperdiagonal, tmpSubdiagonal, this.myZero);
    }

    DiagonalAccess<N> transpose() {
        return new DiagonalAccess<N>(this.mainDiagonal, this.subdiagonal, this.superdiagonal, this.myZero);
    }
}

