/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.decomposition.GeneralEvD;
import org.ojalgo.matrix.decomposition.HermitianEvD;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

abstract class DynamicEvD<N extends Number>
extends EigenvalueDecomposition<N> {
    private boolean myHermitian = false;
    private final EigenvalueDecomposition<N> myNonsymmetricDelegate;
    private final EigenvalueDecomposition<N> mySymmetricDelegate;

    private DynamicEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        this(aFactory, null, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected DynamicEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory, EigenvalueDecomposition<N> aSymmetric, EigenvalueDecomposition<N> aNonsymmetric) {
        super(aFactory);
        this.mySymmetricDelegate = aSymmetric;
        this.myNonsymmetricDelegate = aNonsymmetric;
    }

    @Override
    public boolean equals(MatrixStore<N> other, NumberContext context) {
        if (this.myHermitian) {
            return this.mySymmetricDelegate.equals(other, context);
        }
        return this.myNonsymmetricDelegate.equals(other, context);
    }

    @Override
    public N getDeterminant() {
        if (this.myHermitian) {
            return this.mySymmetricDelegate.getDeterminant();
        }
        return this.myNonsymmetricDelegate.getDeterminant();
    }

    @Override
    public ComplexNumber getTrace() {
        if (this.myHermitian) {
            return this.mySymmetricDelegate.getTrace();
        }
        return this.myNonsymmetricDelegate.getTrace();
    }

    @Override
    public boolean isHermitian() {
        return this.myHermitian;
    }

    @Override
    public boolean isOrdered() {
        if (this.myHermitian) {
            return this.mySymmetricDelegate.isOrdered();
        }
        return this.myNonsymmetricDelegate.isOrdered();
    }

    @Override
    public void reset() {
        super.reset();
        this.myNonsymmetricDelegate.reset();
        this.mySymmetricDelegate.reset();
        this.myHermitian = false;
    }

    @Override
    protected boolean doNonsymmetric(ElementsSupplier<N> matrix, boolean eigenvaluesOnly) {
        this.myHermitian = false;
        return this.myNonsymmetricDelegate.compute(matrix, false, eigenvaluesOnly);
    }

    @Override
    protected boolean doSymmetric(ElementsSupplier<N> matrix, boolean eigenvaluesOnly) {
        this.myHermitian = true;
        return this.mySymmetricDelegate.compute(matrix, true, eigenvaluesOnly);
    }

    @Override
    protected MatrixStore<N> makeD() {
        if (this.myHermitian) {
            return this.mySymmetricDelegate.getD();
        }
        return this.myNonsymmetricDelegate.getD();
    }

    @Override
    protected Array1D<ComplexNumber> makeEigenvalues() {
        if (this.myHermitian) {
            return this.mySymmetricDelegate.getEigenvalues();
        }
        return this.myNonsymmetricDelegate.getEigenvalues();
    }

    @Override
    protected MatrixStore<N> makeV() {
        if (this.myHermitian) {
            return this.mySymmetricDelegate.getV();
        }
        return this.myNonsymmetricDelegate.getV();
    }

    static final class Primitive
    extends DynamicEvD<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY, new HermitianEvD.Primitive(), new GeneralEvD.Primitive());
        }
    }
}

