/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.GenericDecomposition;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.scalar.ComplexNumber;

abstract class EigenvalueDecomposition<N extends Number>
extends GenericDecomposition<N>
implements Eigenvalue<N> {
    private MatrixStore<N> myD = null;
    private Array1D<ComplexNumber> myEigenvalues = null;
    private boolean myEigenvaluesOnly = false;
    private MatrixStore<N> myV = null;

    protected EigenvalueDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public final boolean checkAndCompute(MatrixStore<N> matrix) {
        return this.compute(matrix, MatrixUtils.isHermitian(matrix), false);
    }

    @Override
    public boolean computeValuesOnly(ElementsSupplier<N> matrix) {
        return this.compute(matrix, this.isHermitian(), true);
    }

    @Override
    public final boolean decompose(ElementsSupplier<N> matrix) {
        return this.compute((ElementsSupplier<N>)matrix.get(), this.isHermitian(), false);
    }

    @Override
    public final MatrixStore<N> getD() {
        if (this.myD == null && this.isComputed()) {
            this.myD = this.makeD();
        }
        return this.myD;
    }

    @Override
    public final Array1D<ComplexNumber> getEigenvalues() {
        if (this.myEigenvalues == null && this.isComputed()) {
            this.myEigenvalues = this.makeEigenvalues();
        }
        return this.myEigenvalues;
    }

    @Override
    public final MatrixStore<N> getV() {
        if (this.myV == null && !this.myEigenvaluesOnly && this.isComputed()) {
            this.myV = this.makeV();
        }
        return this.myV;
    }

    @Override
    public void reset() {
        super.reset();
        this.myD = null;
        this.myEigenvalues = null;
        this.myV = null;
        this.myEigenvaluesOnly = false;
    }

    protected abstract boolean doNonsymmetric(ElementsSupplier<N> var1, boolean var2);

    protected abstract boolean doSymmetric(ElementsSupplier<N> var1, boolean var2);

    protected abstract MatrixStore<N> makeD();

    protected abstract Array1D<ComplexNumber> makeEigenvalues();

    protected abstract MatrixStore<N> makeV();

    final boolean compute(ElementsSupplier<N> matrix, boolean symmetric, boolean eigenvaluesOnly) {
        this.reset();
        this.myEigenvaluesOnly = eigenvaluesOnly;
        boolean retVal = false;
        try {
            retVal = symmetric ? this.doSymmetric(matrix, eigenvaluesOnly) : this.doNonsymmetric(matrix, eigenvaluesOnly);
        }
        catch (Exception exc) {
            BasicLogger.error(exc.toString());
            this.reset();
            retVal = false;
        }
        return this.computed(retVal);
    }

    final void setD(MatrixStore<N> newD) {
        this.myD = newD;
    }

    final void setEigenvalues(Array1D<ComplexNumber> newEigenvalues) {
        this.myEigenvalues = newEigenvalues;
    }

    final void setV(MatrixStore<N> newV) {
        this.myV = newV;
    }
}

