/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.matrix.decomposition.AbstractDecomposition;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

abstract class GenericDecomposition<N extends Number>
extends AbstractDecomposition<N> {
    private final PhysicalStore.Factory<N, ? extends DecompositionStore<N>> myFactory;

    private GenericDecomposition() {
        this(null);
    }

    protected GenericDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        this.myFactory = factory;
    }

    public boolean equals(Object someObj) {
        if (someObj instanceof MatrixStore) {
            return this.equals((MatrixStore)someObj, NumberContext.getGeneral(6));
        }
        return super.equals(someObj);
    }

    protected final AggregatorSet<N> aggregator() {
        return this.myFactory.aggregator();
    }

    protected final DecompositionStore<N> copy(Access2D<?> source) {
        return (DecompositionStore)this.myFactory.copy(source);
    }

    protected final FunctionSet<N> function() {
        return this.myFactory.function();
    }

    protected final BasicArray<N> makeArray(int length) {
        return this.myFactory.makeArray(length);
    }

    protected final DecompositionStore<N> makeEye(int numberOfRows, int numberOfColumns) {
        return (DecompositionStore)this.myFactory.makeEye(numberOfRows, numberOfColumns);
    }

    protected final Householder<N> makeHouseholder(int dimension) {
        return this.myFactory.makeHouseholder(dimension);
    }

    protected final MatrixStore.Builder<N> makeIdentity(int dimension) {
        return this.myFactory.builder().makeIdentity(dimension);
    }

    protected final Rotation<N> makeRotation(int aLow, int aHigh, double aCos, double aSin) {
        return this.myFactory.makeRotation(aLow, aHigh, aCos, aSin);
    }

    protected final Rotation<N> makeRotation(int aLow, int aHigh, N aCos, N aSin) {
        return this.myFactory.makeRotation(aLow, aHigh, aCos, aSin);
    }

    protected final DecompositionStore<N> makeZero(int numberOfRows, int numberOfColumns) {
        return (DecompositionStore)this.myFactory.makeZero(numberOfRows, numberOfColumns);
    }

    @Override
    protected final DecompositionStore<N> preallocate(long numberOfRows, long numberOfColumns) {
        return (DecompositionStore)this.myFactory.makeZero(numberOfRows, numberOfColumns);
    }

    protected final Scalar.Factory<N> scalar() {
        return this.myFactory.scalar();
    }

    protected final MatrixStore.Builder<N> wrap(Access2D<?> source) {
        return this.myFactory.builder().makeWrapper(source);
    }
}

