/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.LUDecomposition;
import org.ojalgo.matrix.decomposition.RawLU;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;

public interface LU<N extends Number>
extends LDU<N> {
    public static <N extends Number> LU<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return new LUDecomposition.Big();
        }
        if (tmpNumber instanceof ComplexNumber) {
            return new LUDecomposition.Complex();
        }
        if (tmpNumber instanceof Double) {
            if (16L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return new LUDecomposition.Primitive();
            }
            return new RawLU();
        }
        throw new IllegalArgumentException();
    }

    public static LU<BigDecimal> makeBig() {
        return new LUDecomposition.Big();
    }

    public static LU<ComplexNumber> makeComplex() {
        return new LUDecomposition.Complex();
    }

    public static LU<Double> makePrimitive() {
        return new LUDecomposition.Primitive();
    }

    public boolean computeWithoutPivoting(ElementsSupplier<N> var1);

    public MatrixStore<N> getL();

    public int[] getPivotOrder();

    public int getRank();

    public MatrixStore<N> getU();

    public boolean isSquareAndNotSingular();

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

