/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.BidiagonalDecomposition;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalAccess;
import org.ojalgo.matrix.decomposition.SingularValueDecomposition;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

abstract class SVDnew32<N extends Number>
extends SingularValueDecomposition<N> {
    static void doCase1(double[] s, double[] e, int p, int k, DecompositionStore<?> aQ2) {
        double f = e[p - 2];
        e[p - 2] = PrimitiveMath.ZERO;
        for (int j = p - 2; j >= k; --j) {
            double t = Math.hypot(s[j], f);
            double cs = s[j] / t;
            double sn = f / t;
            s[j] = t;
            if (j != k) {
                f = -sn * e[j - 1];
                e[j - 1] = cs * e[j - 1];
            }
            if (aQ2 == null) continue;
            aQ2.rotateRight(p - 1, j, cs, sn);
        }
    }

    static void doCase2(double[] s, double[] e, int p, int k, DecompositionStore<?> aQ1) {
        double f = e[k - 1];
        e[k - 1] = PrimitiveMath.ZERO;
        for (int j = k; j < p; ++j) {
            double t = Math.hypot(s[j], f);
            double cs = s[j] / t;
            double sn = f / t;
            s[j] = t;
            f = -sn * e[j];
            e[j] = cs * e[j];
            if (aQ1 == null) continue;
            aQ1.rotateRight(k - 1, j, cs, sn);
        }
    }

    static void doCase3(double[] s, double[] e, int p, int k, DecompositionStore<?> aQ1, DecompositionStore<?> aQ2) {
        int indPm1 = p - 1;
        int indPm2 = p - 2;
        double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(s[indPm1]), Math.abs(s[indPm2])), Math.abs(e[indPm2])), Math.abs(s[k])), Math.abs(e[k]));
        double sPm1 = s[indPm1] / scale;
        double sPm2 = s[indPm2] / scale;
        double ePm2 = e[indPm2] / scale;
        double sK = s[k] / scale;
        double eK = e[k] / scale;
        double b = ((sPm2 + sPm1) * (sPm2 - sPm1) + ePm2 * ePm2) / PrimitiveMath.TWO;
        double c = sPm1 * ePm2 * (sPm1 * ePm2);
        double shift = Math.sqrt(b * b + c);
        if (b < PrimitiveMath.ZERO) {
            shift = -shift;
        }
        shift = c / (b + shift);
        double f = (sK + sPm1) * (sK - sPm1) + shift;
        double g = sK * eK;
        for (int j = k; j < indPm1; ++j) {
            double t = Math.hypot(f, g);
            double cs = f / t;
            double sn = g / t;
            if (j != k) {
                e[j - 1] = t;
            }
            f = cs * s[j] + sn * e[j];
            e[j] = cs * e[j] - sn * s[j];
            g = sn * s[j + 1];
            s[j + 1] = cs * s[j + 1];
            if (aQ2 != null) {
                aQ2.rotateRight(j + 1, j, cs, sn);
            }
            t = Math.hypot(f, g);
            cs = f / t;
            sn = g / t;
            s[j] = t;
            f = cs * e[j] + sn * s[j + 1];
            s[j + 1] = -sn * e[j] + cs * s[j + 1];
            g = sn * e[j + 1];
            e[j + 1] = cs * e[j + 1];
            if (aQ1 == null) continue;
            aQ1.rotateRight(j + 1, j, cs, sn);
        }
        e[indPm2] = f;
    }

    static void doCase4(double[] s, int k, DecompositionStore<?> aQ1, DecompositionStore<?> aQ2) {
        int tmpDiagDim = s.length;
        double tmpSk = s[k];
        if (tmpSk < PrimitiveMath.ZERO) {
            s[k] = -tmpSk;
            if (aQ2 != null) {
                aQ2.negateColumn(k);
            }
        } else if (tmpSk == PrimitiveMath.ZERO) {
            s[k] = PrimitiveMath.ZERO;
        }
        for (int tmpK = k; tmpK < tmpDiagDim - 1 && !(s[tmpK] >= s[tmpK + 1]); ++tmpK) {
            double t = s[tmpK];
            s[tmpK] = s[tmpK + 1];
            s[tmpK + 1] = t;
            if (aQ1 != null) {
                aQ1.exchangeColumns(tmpK + 1, tmpK);
            }
            if (aQ2 == null) continue;
            aQ2.exchangeColumns(tmpK + 1, tmpK);
        }
    }

    static Array1D<Double> toDiagonal(DiagonalAccess<?> bidiagonal, DecompositionStore<?> aQ1, DecompositionStore<?> aQ2) {
        int tmpDiagDim = bidiagonal.mainDiagonal.size();
        double[] s = bidiagonal.mainDiagonal.toRawCopy();
        double[] e = new double[tmpDiagDim];
        int tmpOffLength = bidiagonal.superdiagonal.size();
        for (int i = 0; i < tmpOffLength; ++i) {
            e[i] = bidiagonal.superdiagonal.doubleValue(i);
        }
        int p = tmpDiagDim;
        block7: while (p > 0) {
            int kase = 0;
            int k = 0;
            for (k = p - 2; k >= -1 && k != -1; --k) {
                if (!(Math.abs(e[k]) <= PrimitiveMath.TINY + PrimitiveMath.MACHINE_EPSILON * (Math.abs(s[k]) + Math.abs(s[k + 1])))) continue;
                e[k] = PrimitiveMath.ZERO;
                break;
            }
            if (k == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k && ks != k; --ks) {
                    double t = (ks != p ? Math.abs(e[ks]) : PrimitiveMath.ZERO) + (ks != k + 1 ? Math.abs(e[ks - 1]) : PrimitiveMath.ZERO);
                    if (!(Math.abs(s[ks]) <= PrimitiveMath.TINY + PrimitiveMath.MACHINE_EPSILON * t)) continue;
                    s[ks] = PrimitiveMath.ZERO;
                    break;
                }
                if (ks == k) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k = ks;
                }
            }
            ++k;
            switch (kase) {
                case 1: {
                    SVDnew32.doCase1(s, e, p, k, aQ2);
                    continue block7;
                }
                case 2: {
                    SVDnew32.doCase2(s, e, p, k, aQ1);
                    continue block7;
                }
                case 3: {
                    SVDnew32.doCase3(s, e, p, k, aQ1, aQ2);
                    continue block7;
                }
                case 4: {
                    SVDnew32.doCase4(s, k, aQ1, aQ2);
                    --p;
                    continue block7;
                }
            }
            throw new IllegalStateException();
        }
        return Array1D.PRIMITIVE.wrap(PrimitiveArray.wrap(s));
    }

    protected SVDnew32(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory, BidiagonalDecomposition<N> aBidiagonal) {
        super(aFactory, aBidiagonal);
    }

    @Override
    public boolean equals(MatrixStore<N> other, NumberContext context) {
        return MatrixUtils.equals(other, this, NumberContext.getGeneral(6));
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public boolean isSolvable() {
        return this.isComputed();
    }

    @Override
    protected boolean doCompute(ElementsSupplier<N> aMtrx, boolean singularValuesOnly, boolean fullSize) {
        this.computeBidiagonal(aMtrx, fullSize);
        DiagonalAccess tmpBidiagonal = this.getBidiagonalAccessD();
        DecompositionStore tmpQ1 = singularValuesOnly ? null : this.getBidiagonalQ1();
        DecompositionStore tmpQ2 = singularValuesOnly ? null : this.getBidiagonalQ2();
        Array1D<Double> tmpDiagonal = SVDnew32.toDiagonal(tmpBidiagonal, tmpQ1, tmpQ2);
        this.setSingularValues(tmpDiagonal);
        return this.computed(true);
    }

    @Override
    protected MatrixStore<N> makeD() {
        return this.wrap(new DiagonalAccess<Double>(this.getSingularValues(), null, null, PrimitiveMath.ZERO)).get();
    }

    @Override
    protected MatrixStore<N> makeQ1() {
        return this.getBidiagonalQ1();
    }

    @Override
    protected MatrixStore<N> makeQ2() {
        return this.getBidiagonalQ2();
    }

    @Override
    protected Array1D<Double> makeSingularValues() {
        throw new IllegalStateException("Should never have to be called!");
    }

    static final class Primitive
    extends SVDnew32<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY, new BidiagonalDecomposition.Primitive());
        }
    }

    static final class Complex
    extends SVDnew32<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY, new BidiagonalDecomposition.Complex());
        }
    }

    static final class Big
    extends SVDnew32<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY, new BidiagonalDecomposition.Big());
        }
    }
}

