/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawSingularValue;
import org.ojalgo.matrix.decomposition.SVDnew32;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;

public interface SingularValue<N extends Number>
extends MatrixDecomposition<N>,
MatrixDecomposition.Solver<N>,
MatrixDecomposition.EconomySize<N>,
MatrixDecomposition.Values<N> {
    public static <N extends Number> SingularValue<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return new SVDnew32.Big();
        }
        if (tmpNumber instanceof ComplexNumber) {
            return new SVDnew32.Complex();
        }
        if (tmpNumber instanceof Double) {
            if (2048L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return new SVDnew32.Primitive();
            }
            return new RawSingularValue();
        }
        throw new IllegalArgumentException();
    }

    public static SingularValue<BigDecimal> makeBig() {
        return new SVDnew32.Big();
    }

    public static SingularValue<ComplexNumber> makeComplex() {
        return new SVDnew32.Complex();
    }

    public static SingularValue<Double> makePrimitive() {
        return new SVDnew32.Primitive();
    }

    public double getCondition();

    public MatrixStore<N> getD();

    public double getFrobeniusNorm();

    public double getKyFanNorm(int var1);

    public double getOperatorNorm();

    public MatrixStore<N> getQ1();

    public MatrixStore<N> getQ2();

    public int getRank();

    public Array1D<Double> getSingularValues();

    public double getTraceNorm();

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

