/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.BidiagonalDecomposition;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalAccess;
import org.ojalgo.matrix.decomposition.GenericDecomposition;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.scalar.Scalar;

abstract class SingularValueDecomposition<N extends Number>
extends GenericDecomposition<N>
implements SingularValue<N> {
    private final BidiagonalDecomposition<N> myBidiagonal;
    private transient MatrixStore<N> myD;
    private boolean myFullSize = false;
    private transient MatrixStore<N> myInverse;
    private transient MatrixStore<N> myQ1;
    private transient MatrixStore<N> myQ2;
    private transient Array1D<Double> mySingularValues;
    private boolean mySingularValuesOnly = false;
    private boolean myTransposed = false;

    private SingularValueDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        this(aFactory, null);
    }

    protected SingularValueDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory, BidiagonalDecomposition<N> aBidiagonal) {
        super(aFactory);
        this.myBidiagonal = aBidiagonal;
    }

    @Override
    public boolean computeValuesOnly(ElementsSupplier<N> matrix) {
        return this.compute(matrix, true, false);
    }

    @Override
    public boolean decompose(ElementsSupplier<N> matrix) {
        return this.compute(matrix, false, this.isFullSize());
    }

    @Override
    public double getCondition() {
        Array1D<Double> tmpSingularValues = this.getSingularValues();
        return tmpSingularValues.doubleValue(0L) / tmpSingularValues.doubleValue(tmpSingularValues.length - 1L);
    }

    @Override
    public MatrixStore<N> getD() {
        if (this.myD == null && this.isComputed()) {
            this.myD = this.makeD();
        }
        return this.myD;
    }

    @Override
    public double getFrobeniusNorm() {
        double retVal = PrimitiveMath.ZERO;
        Array1D<Double> tmpSingularValues = this.getSingularValues();
        for (int i = tmpSingularValues.size() - 1; i >= 0; --i) {
            double tmpVal = tmpSingularValues.doubleValue(i);
            retVal += tmpVal * tmpVal;
        }
        return Math.sqrt(retVal);
    }

    @Override
    public MatrixStore<N> getInverse() {
        if (this.myInverse == null) {
            MatrixStore<N> tmpQ1 = this.getQ1();
            MatrixStore<N> tmpD = this.getD();
            int tmpRowDim = (int)tmpD.countRows();
            int tmpColDim = (int)tmpQ1.countRows();
            DecompositionStore tmpMtrx = this.makeZero(tmpRowDim, tmpColDim);
            for (int i = 0; i < tmpRowDim; ++i) {
                if (tmpD.isZero(i, i)) continue;
                double tmpSingularValue = tmpD.doubleValue(i, i);
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpMtrx.set((long)i, (long)j, (Number)((Scalar)((Scalar)tmpQ1.toScalar(j, i).conjugate()).divide(tmpSingularValue)).getNumber());
                }
            }
            this.myInverse = this.getQ2().multiply(tmpMtrx);
        }
        return this.myInverse;
    }

    @Override
    public MatrixStore<N> getInverse(DecompositionStore<N> preallocated) {
        if (this.myInverse == null) {
            MatrixStore<N> tmpQ1 = this.getQ1();
            MatrixStore<N> tmpD = this.getD();
            int tmpRowDim = (int)tmpD.countRows();
            int tmpColDim = (int)tmpQ1.countRows();
            DecompositionStore tmpMtrx = preallocated;
            Object tmpZero = this.scalar().zero().getNumber();
            for (int i = 0; i < tmpRowDim; ++i) {
                if (tmpD.isZero(i, i)) {
                    tmpMtrx.fillRow((long)i, 0L, tmpZero);
                    continue;
                }
                Object tmpSingularValue = tmpD.get(i, i);
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpMtrx.set((long)i, (long)j, (Number)((Scalar)tmpQ1.toScalar(j, i).divide(tmpSingularValue)).getNumber());
                }
            }
            this.myInverse = this.getQ2().multiply(tmpMtrx);
        }
        return this.myInverse;
    }

    @Override
    public double getKyFanNorm(int k) {
        Array1D<Double> tmpSingularValues = this.getSingularValues();
        double retVal = PrimitiveMath.ZERO;
        for (int i = Math.min(tmpSingularValues.size(), k) - 1; i >= 0; --i) {
            retVal += tmpSingularValues.doubleValue(i);
        }
        return retVal;
    }

    @Override
    public double getOperatorNorm() {
        return this.getSingularValues().doubleValue(0L);
    }

    @Override
    public MatrixStore<N> getQ1() {
        if (this.myQ1 == null && !this.mySingularValuesOnly && this.isComputed()) {
            this.myQ1 = this.myTransposed ? this.makeQ2() : this.makeQ1();
        }
        return this.myQ1;
    }

    @Override
    public MatrixStore<N> getQ2() {
        if (this.myQ2 == null && !this.mySingularValuesOnly && this.isComputed()) {
            this.myQ2 = this.myTransposed ? this.makeQ1() : this.makeQ2();
        }
        return this.myQ2;
    }

    @Override
    public int getRank() {
        Array1D<Double> tmpSingularValues = this.getSingularValues();
        int retVal = tmpSingularValues.size();
        double tmpTolerance = (double)retVal * tmpSingularValues.doubleValue(0L) * PrimitiveMath.MACHINE_EPSILON;
        for (int i = retVal - 1; i >= 0; --i) {
            if (tmpSingularValues.doubleValue(i) <= tmpTolerance) {
                --retVal;
                continue;
            }
            return retVal;
        }
        return retVal;
    }

    @Override
    public Array1D<Double> getSingularValues() {
        if (this.mySingularValues == null && this.isComputed()) {
            this.mySingularValues = this.makeSingularValues();
        }
        return this.mySingularValues;
    }

    @Override
    public double getTraceNorm() {
        return this.getKyFanNorm(this.getSingularValues().size());
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) {
        this.decompose(this.wrap(original));
        return this.getInverse();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(original));
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isFullSize() {
        return this.myFullSize;
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.preallocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.preallocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.myBidiagonal.reset();
        this.myD = null;
        this.myQ1 = null;
        this.myQ2 = null;
        this.myInverse = null;
        this.mySingularValuesOnly = false;
        this.myTransposed = false;
    }

    @Override
    public void setFullSize(boolean fullSize) {
        this.myFullSize = fullSize;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) {
        this.decompose(this.wrap(body));
        return this.solve(this.wrap(rhs));
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(body));
        return this.solve(rhs, preallocated);
    }

    @Override
    public final MatrixStore<N> solve(ElementsSupplier<N> rhs) {
        return this.getInverse().multiply(rhs.get());
    }

    @Override
    public MatrixStore<N> solve(ElementsSupplier<N> rhs, DecompositionStore<N> preallocated) {
        preallocated.fillByMultiplying(this.getInverse(), (Access1D<N>)rhs.get());
        return preallocated;
    }

    protected boolean compute(ElementsSupplier<N> matrix, boolean singularValuesOnly, boolean fullSize) {
        this.reset();
        this.myTransposed = matrix.countRows() < matrix.countColumns();
        this.mySingularValuesOnly = singularValuesOnly;
        boolean retVal = false;
        try {
            retVal = this.doCompute((ElementsSupplier<N>)(this.myTransposed ? matrix.get().conjugate() : matrix), singularValuesOnly, fullSize);
        }
        catch (Exception anException) {
            BasicLogger.error(anException.toString());
            this.reset();
            retVal = false;
        }
        return this.computed(retVal);
    }

    protected boolean computeBidiagonal(ElementsSupplier<N> matrix, boolean fullSize) {
        this.myBidiagonal.setFullSize(fullSize);
        return this.myBidiagonal.decompose(matrix);
    }

    protected abstract boolean doCompute(ElementsSupplier<N> var1, boolean var2, boolean var3);

    protected DiagonalAccess<N> getBidiagonalAccessD() {
        return this.myBidiagonal.getDiagonalAccessD();
    }

    protected DecompositionStore<N> getBidiagonalQ1() {
        return (DecompositionStore)this.myBidiagonal.getQ1();
    }

    protected DecompositionStore<N> getBidiagonalQ2() {
        return (DecompositionStore)this.myBidiagonal.getQ2();
    }

    protected boolean isTransposed() {
        return this.myTransposed;
    }

    protected abstract MatrixStore<N> makeD();

    protected abstract MatrixStore<N> makeQ1();

    protected abstract MatrixStore<N> makeQ2();

    protected abstract Array1D<Double> makeSingularValues();

    void setD(MatrixStore<N> someD) {
        this.myD = someD;
    }

    void setQ1(MatrixStore<N> someQ1) {
        this.myQ1 = someQ1;
    }

    void setQ2(MatrixStore<N> someQ2) {
        this.myQ2 = someQ2;
    }

    void setSingularValues(Array1D<Double> someSingularValues) {
        this.mySingularValues = someSingularValues;
    }
}

