/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.SelectingStore;
import org.ojalgo.scalar.Scalar;

final class ColumnsStore<N extends Number>
extends SelectingStore<N> {
    private final int[] myColumns;
    private final int myFirst;

    private ColumnsStore(MatrixStore<N> aBase) {
        this(aBase, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    ColumnsStore(int aFirst, int aLimit, MatrixStore<N> aBase) {
        super((int)aBase.countRows(), aLimit - aFirst, aBase);
        this.myColumns = null;
        this.myFirst = aFirst;
    }

    ColumnsStore(MatrixStore<N> aBase, int ... someColumns) {
        super((int)aBase.countRows(), someColumns.length, aBase);
        this.myColumns = someColumns;
        this.myFirst = 0;
    }

    @Override
    public double doubleValue(long row, long column) {
        if (this.myColumns != null) {
            return this.getBase().doubleValue(row, this.myColumns[(int)column]);
        }
        return this.getBase().doubleValue(row, (long)this.myFirst + column);
    }

    @Override
    public N get(long row, long column) {
        if (this.myColumns != null) {
            return this.getBase().get(row, this.myColumns[(int)column]);
        }
        return this.getBase().get(row, (long)this.myFirst + column);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        if (this.myColumns != null) {
            return this.getBase().toScalar(row, this.myColumns[(int)column]);
        }
        return this.getBase().toScalar(row, (long)this.myFirst + column);
    }
}

