/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;

final class IdentityStore<N extends Number>
extends FactoryStore<N> {
    private IdentityStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        ProgrammingError.throwForIllegalInvocation();
    }

    IdentityStore(PhysicalStore.Factory<N, ?> factory, int dimension) {
        super(factory, dimension, dimension);
    }

    @Override
    public MatrixStore<N> conjugate() {
        return this;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        if (aRow == aCol) {
            return PrimitiveMath.ONE;
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public int firstInColumn(int col) {
        return col;
    }

    @Override
    public int firstInRow(int row) {
        return row;
    }

    @Override
    public N get(long aRow, long aCol) {
        if (aRow == aCol) {
            return this.factory().scalar().one().getNumber();
        }
        return this.factory().scalar().zero().getNumber();
    }

    @Override
    public int limitOfColumn(int col) {
        return col + 1;
    }

    @Override
    public int limitOfRow(int row) {
        return row + 1;
    }

    @Override
    public MatrixStore<N> multiply(Access1D<N> right) {
        if ((long)this.getColDim() == right.count()) {
            return (MatrixStore)this.factory().columns(right);
        }
        if (right instanceof MatrixStore) {
            return ((MatrixStore)right).copy();
        }
        return super.multiply(right);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        if (row == column) {
            return this.factory().scalar().one();
        }
        return this.factory().scalar().zero();
    }

    @Override
    public MatrixStore<N> transpose() {
        return this;
    }

    @Override
    protected void supplyNonZerosTo(ElementsConsumer<N> consumer) {
        consumer.fillDiagonal(0L, 0L, this.factory().scalar().one().getNumber());
    }
}

