/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.DotProduct;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.store.operation.SubtractScaledVector;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;

public final class HouseholderLeft
extends MatrixOperation {
    public static final HouseholderLeft SETUP = new HouseholderLeft();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] data, int structure, int first, int limit, Householder.Big householder) {
        BigDecimal[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        BigDecimal tmpBeta = householder.beta;
        for (int j = first; j < limit; ++j) {
            int i;
            BigDecimal tmpScale = BigMath.ZERO;
            int tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                tmpScale = BigFunction.ADD.invoke(tmpScale, BigFunction.MULTIPLY.invoke(tmpHouseholderVector[i], data[tmpIndex++]));
            }
            tmpScale = BigFunction.MULTIPLY.invoke(tmpScale, tmpBeta);
            tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                data[tmpIndex] = BigFunction.SUBTRACT.invoke(data[tmpIndex], BigFunction.MULTIPLY.invoke(tmpScale, tmpHouseholderVector[i]));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(ComplexNumber[] data, int structure, int first, int limit, Householder.Complex householder) {
        ComplexNumber[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        ComplexNumber tmpBeta = householder.beta;
        for (int j = first; j < limit; ++j) {
            int i;
            ComplexNumber tmpScale = ComplexNumber.ZERO;
            int tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                tmpScale = tmpScale.add(tmpHouseholderVector[i].conjugate().multiply(data[tmpIndex++]));
            }
            tmpScale = tmpScale.multiply(tmpBeta);
            tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                data[tmpIndex] = data[tmpIndex].subtract(tmpScale.multiply(tmpHouseholderVector[i]));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(double[] data, int structure, int first, int limit, Householder.Primitive householder) {
        double[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        double tmpBeta = householder.beta;
        for (int j = first; j < limit; ++j) {
            double tmpScale = DotProduct.invoke(data, j * structure, tmpHouseholderVector, 0, tmpFirstNonZero, structure);
            SubtractScaledVector.invoke(data, j * structure, tmpHouseholderVector, 0, tmpScale *= tmpBeta, tmpFirstNonZero, structure);
        }
    }

    private HouseholderLeft() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

