/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.ojalgo.ProgrammingError;
import org.ojalgo.netio.BufferedInputStreamReader;

public final class ResourceLocator {
    private String myHost = null;
    private String myPath = null;
    private int myPort = -1;
    private Map<String, String> myQueryParameters = new TreeMap<String, String>();
    private String myScheme = "http";

    public String addQueryParameter(String aKey, String aValue) {
        return this.myQueryParameters.put(aKey, aValue);
    }

    public BufferedReader getStreamReader() {
        try {
            return new BufferedInputStreamReader(this.toURL().openStream());
        }
        catch (IOException anException) {
            return null;
        }
    }

    public String removeQueryParameter(String aKey) {
        return this.myQueryParameters.remove(aKey);
    }

    public void setHost(String someHost) {
        this.myHost = someHost;
    }

    public void setPath(String somePath) {
        this.myPath = somePath;
    }

    public void setPort(int somePort) {
        this.myPort = somePort;
    }

    public void setQueryParameters(Map<String, String> someQueryParameters) {
        this.myQueryParameters = someQueryParameters;
    }

    public void setScheme(String someScheme) {
        this.myScheme = someScheme;
    }

    private URI makeURI() {
        try {
            return new URI(this.myScheme, null, this.myHost, this.myPort, this.myPath, this.query(), null);
        }
        catch (URISyntaxException anException) {
            throw new ProgrammingError(anException);
        }
    }

    private String query() {
        if (this.myQueryParameters.size() >= 1) {
            StringBuilder retVal = new StringBuilder();
            for (Map.Entry<String, String> tmpEntry : this.myQueryParameters.entrySet()) {
                retVal.append(tmpEntry.getKey());
                retVal.append('=');
                retVal.append(tmpEntry.getValue());
                retVal.append('&');
            }
            retVal.setLength(retVal.length() - 1);
            return retVal.toString();
        }
        return null;
    }

    private URL toURL() {
        try {
            return this.makeURI().toURL();
        }
        catch (MalformedURLException anException) {
            throw new ProgrammingError(anException);
        }
    }
}

