/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConvexSolver;

abstract class ConstrainedSolver
extends ConvexSolver {
    protected ConstrainedSolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    abstract MatrixStore<Double> getIterationA();

    abstract MatrixStore<Double> getIterationB();

    @Override
    protected boolean validate() {
        super.validate();
        MatrixStore<Double> tmpA = this.getIterationA();
        MatrixStore<Double> tmpB = this.getIterationB();
        if (tmpA != null && tmpB == null || tmpA == null && tmpB != null) {
            throw new IllegalArgumentException("Either A or B is null, and the other one is not!");
        }
        if (tmpA != null) {
            this.myLU.decompose(tmpA.countRows() < tmpA.countColumns() ? tmpA.transpose() : tmpA);
            if ((long)this.myLU.getRank() != tmpA.countRows()) {
                throw new IllegalArgumentException("A must have full (row) rank!");
            }
        }
        this.setState(Optimisation.State.VALID);
        return true;
    }
}

