/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.AbstractContinuous;
import org.ojalgo.random.RandomUtils;

public class Normal
extends AbstractContinuous {
    private static final long serialVersionUID = 7164712313114018919L;
    private final double myLocation;
    private final double myScale;

    public Normal() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    public Normal(double aLocation, double aScale) {
        this.myLocation = aLocation;
        this.myScale = aScale;
    }

    @Override
    public double getDistribution(double aValue) {
        return (PrimitiveMath.ONE + RandomUtils.erf((aValue - this.myLocation) / (this.myScale * PrimitiveMath.SQRT_TWO))) / PrimitiveMath.TWO;
    }

    @Override
    public double getExpected() {
        return this.myLocation;
    }

    @Override
    public double getProbability(double aValue) {
        double tmpVal = (aValue - this.myLocation) / this.myScale;
        return Math.exp(tmpVal * tmpVal / -PrimitiveMath.TWO) / (this.myScale * PrimitiveMath.SQRT_TWO_PI);
    }

    @Override
    public double getQuantile(double aProbality) {
        this.checkProbabilty(aProbality);
        return this.myScale * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(PrimitiveMath.TWO * aProbality - PrimitiveMath.ONE) + this.myLocation;
    }

    @Override
    public double getStandardDeviation() {
        return this.myScale;
    }

    @Override
    protected double generate() {
        return this.random().nextGaussian() * this.myScale + this.myLocation;
    }
}

